#!/bin/bash
# This script monitors the backend log
# restarts backend if a firewire No Input in 300 msec... error occurs
# Sends email if a recording fails

set -e
. /etc/opt/mythtv/mythtv.conf
scriptname=`readlink -e "$0"`
scriptpath=`dirname "$scriptname"`

logfile=/var/log/mythtv/mythbackend.log
# These errors are monitored:
# 2011-10-19 02:00:01.067 Updating status for Flashpoint:Grounded on cardid 3 (Tuning => Recorder Failed)
# 2011-10-09 11:00:00.857 Updating status for "Shake It Up!":"Shrink It Up" on cardid 7 (Recording => Recorder Failed)
# 2011-11-10 10:19:00.575 Updating status for "Hawaii Five-0":"Thu Nov 10 09:04:00 2011" on cardid 7 (Recording => Recorder Failed)
# 2011-10-09 19:12:34.361 LFireDev(00169204EBAE0000), Warning: No Input in 300 msec...

tail -f $logfile | (
    while true ; do
        read date time msg
        if [[ "$msg" == *' Recorder Failed)' ]] ; then
            msgtime=`date -d  "$date $time" "+%s"`
            now=`date "+%s"`
            if (( now - msgtime < 60 )) ; then 
                "$scriptpath/notify.sh" "Recorder Failed" "$msg"
                echo $date $time "$msg"
            fi
        fi
        if [[ "$msg" == *' No Input in 300 msec...' ]] ; then
            msgtime=`date -d  "$date $time" "+%s"`
            now=`date "+%s"`
            if (( now - msgtime < 60 )) ; then 
                if (( now - lastrestart > 300 )) ; then
                    echo $date $time "$msg"
                    echo "Restarting back end because of No Input in 300 msec"
                    sudo restart mythtv-backend || echo "Restart failed"
                    lastrestart=$now
                    "$scriptpath/notify.sh" "Firewire Glitch" "$msg"
                fi
            fi
        fi
    done
)
