// -*- Mode: c++ -*-
/*******************************************************************
 * CRCIpNetworkRecorder
 *
 * Copyright (C) Her Majesty the Queen in Right of Canada, 2006
 * Communications Research Centre (CRC)
 *
 * Distributed as part of MythTV (www.mythtv.org)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Contact:
 * Francois Lefebvre <francois [dot] lefebvre [at] crc [dot] ca>
 * Web: http://www.crc.ca
 * 
 * 2006/04 Jean-Francois Roy for CRC
 *    Initial release
 *
 ********************************************************************/

#ifndef CRCIPNETWORKRECORDER_H
#define CRCIPNETWORKRECORDER_H

#include <sys/time.h>

#include "dtvrecorder.h"
#ifdef USING_H264TOOLS
  #include "h264utils.h"
#endif

extern "C" {
#include "../libavformat/avformat.h"
}

class CRCIpNetworkRecorder : public DTVRecorder
{
  public:
    CRCIpNetworkRecorder(TVRec *rec);
    ~CRCIpNetworkRecorder();

    void SetOptionsFromProfile(RecordingProfile *profile,
                               const QString &videodev,
                               const QString &audiodev,
                               const QString &vbidev);

    bool Open(void);
    void Reset(void);
    void StartRecording(void);

  private:
    void Close(void);

    ssize_t ProcessData(unsigned char *buffer, ssize_t len);
#ifdef USING_H264TOOLS
    bool FindH264Keyframes(const TSPacket* tspacket);
    void HandleH264Keyframe(void);
#endif

    void FinishRecording(void);

    // UDP support (using libavformat)
    URLContext *url_context;
    unsigned char *network_buffer;

    // MPEG-2 Transport Stream support
    bool seen_PAT_packet;
    uint PMT_id;
    uint video_pid;
    uint video_stream_type;

    bool PES_synced;

    // H.264 support
#ifdef USING_H264TOOLS
    H264::KeyframeSequencer h264_kf_seq;
    bool seen_SPS;
#endif

};

#endif // CRCIPNETWORKRECORDER_H

