-- MySQL dump 10.10
--
-- Host: localhost    Database: mythconverg
-- ------------------------------------------------------
-- Server version	5.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `callsignnetworkmap`
--

DROP TABLE IF EXISTS `callsignnetworkmap`;
CREATE TABLE `callsignnetworkmap` (
  `id` int(11) NOT NULL auto_increment,
  `callsign` varchar(20) NOT NULL default '',
  `network` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `callsign` (`callsign`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `callsignnetworkmap`
--


/*!40000 ALTER TABLE `callsignnetworkmap` DISABLE KEYS */;
LOCK TABLES `callsignnetworkmap` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `callsignnetworkmap` ENABLE KEYS */;

--
-- Table structure for table `capturecard`
--

DROP TABLE IF EXISTS `capturecard`;
CREATE TABLE `capturecard` (
  `cardid` int(10) unsigned NOT NULL auto_increment,
  `videodevice` varchar(128) default NULL,
  `audiodevice` varchar(128) default NULL,
  `vbidevice` varchar(128) default NULL,
  `cardtype` varchar(32) default 'V4L',
  `defaultinput` varchar(32) default 'Television',
  `audioratelimit` int(11) default NULL,
  `hostname` varchar(255) default NULL,
  `dvb_swfilter` int(11) default '0',
  `dvb_recordts` int(11) default '1',
  `dvb_sat_type` int(11) NOT NULL default '0',
  `dvb_wait_for_seqstart` int(11) NOT NULL default '1',
  `skipbtaudio` tinyint(1) default '0',
  `dvb_on_demand` tinyint(4) NOT NULL default '0',
  `dvb_diseqc_type` smallint(6) default NULL,
  `firewire_port` int(10) unsigned NOT NULL default '0',
  `firewire_node` int(10) unsigned NOT NULL default '2',
  `firewire_speed` int(10) unsigned NOT NULL default '0',
  `firewire_model` varchar(32) default NULL,
  `firewire_connection` int(10) unsigned NOT NULL default '0',
  `dvb_hw_decoder` int(11) default '0',
  `dbox2_port` int(10) unsigned NOT NULL default '31338',
  `dbox2_httpport` int(10) unsigned NOT NULL default '80',
  `dbox2_host` varchar(32) default NULL,
  `signal_timeout` int(11) NOT NULL default '1000',
  `channel_timeout` int(11) NOT NULL default '3000',
  `parentid` int(10) NOT NULL default '0',
  `dvb_tuning_delay` int(10) unsigned NOT NULL default '0',
  `contrast` int(11) NOT NULL default '0',
  `brightness` int(11) NOT NULL default '0',
  `colour` int(11) NOT NULL default '0',
  `hue` int(11) NOT NULL default '0',
  `diseqcid` int(10) unsigned default NULL,
  PRIMARY KEY  (`cardid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `capturecard`
--


/*!40000 ALTER TABLE `capturecard` DISABLE KEYS */;
LOCK TABLES `capturecard` WRITE;
INSERT INTO `capturecard` VALUES (1,'0','','','DVB','DVBInput',NULL,'zenslack',0,1,0,1,0,0,NULL,0,2,0,NULL,0,0,31338,80,NULL,60000,62500,0,0,0,0,0,0,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `capturecard` ENABLE KEYS */;

--
-- Table structure for table `cardinput`
--

DROP TABLE IF EXISTS `cardinput`;
CREATE TABLE `cardinput` (
  `cardinputid` int(10) unsigned NOT NULL auto_increment,
  `cardid` int(10) unsigned NOT NULL default '0',
  `sourceid` int(10) unsigned NOT NULL default '0',
  `inputname` varchar(32) NOT NULL default '',
  `externalcommand` varchar(128) default NULL,
  `preference` int(11) NOT NULL default '0',
  `shareable` char(1) default 'N',
  `tunechan` varchar(10) default NULL,
  `startchan` varchar(10) default NULL,
  `freetoaironly` tinyint(1) default '1',
  `diseqc_port` smallint(6) default NULL,
  `diseqc_pos` float default NULL,
  `lnb_lof_switch` int(11) default '11700000',
  `lnb_lof_hi` int(11) default '10600000',
  `lnb_lof_lo` int(11) default '9750000',
  `displayname` varchar(64) NOT NULL default '',
  `radioservices` tinyint(1) default '1',
  `childcardid` int(10) NOT NULL default '0',
  `dishnet_eit` tinyint(1) NOT NULL default '0',
  `recpriority` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cardinputid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cardinput`
--


/*!40000 ALTER TABLE `cardinput` DISABLE KEYS */;
LOCK TABLES `cardinput` WRITE;
INSERT INTO `cardinput` VALUES (1,1,1,'DVBInput',NULL,0,'N',NULL,'1',0,NULL,NULL,11700000,10600000,9750000,'',1,0,0,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `cardinput` ENABLE KEYS */;

--
-- Table structure for table `channel`
--

DROP TABLE IF EXISTS `channel`;
CREATE TABLE `channel` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `channum` varchar(10) NOT NULL default '',
  `freqid` varchar(10) default NULL,
  `sourceid` int(10) unsigned default NULL,
  `callsign` varchar(20) NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  `icon` varchar(255) NOT NULL default 'none',
  `finetune` int(11) default NULL,
  `videofilters` varchar(255) NOT NULL default '',
  `xmltvid` varchar(64) NOT NULL default '',
  `recpriority` int(10) NOT NULL default '0',
  `contrast` int(11) default '32768',
  `brightness` int(11) default '32768',
  `colour` int(11) default '32768',
  `hue` int(11) default '32768',
  `tvformat` varchar(10) NOT NULL default 'Default',
  `commfree` tinyint(4) NOT NULL default '0',
  `visible` tinyint(1) NOT NULL default '1',
  `outputfilters` varchar(255) NOT NULL default '',
  `useonairguide` tinyint(1) default '0',
  `mplexid` smallint(6) default NULL,
  `serviceid` mediumint(8) unsigned default NULL,
  `atscsrcid` int(11) default NULL,
  `tmoffset` int(11) NOT NULL default '0',
  `atsc_major_chan` int(10) unsigned NOT NULL default '0',
  `atsc_minor_chan` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`chanid`),
  KEY `channel_src` (`channum`,`sourceid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `channel`
--


/*!40000 ALTER TABLE `channel` DISABLE KEYS */;
LOCK TABLES `channel` WRITE;
INSERT INTO `channel` VALUES (29130,'28130',NULL,1,'Test-R','Test-R','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',0,27,28130,NULL,0,0,0),(29107,'28107',NULL,1,'Bayerisches FS','Bayerisches FS','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28107,NULL,0,0,0),(29111,'28111',NULL,1,'WDR KÃ¶ln','WDR KÃ¶ln','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28111,NULL,0,0,0),(29109,'28109',NULL,1,'arte','arte','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28109,NULL,0,0,0),
(29106,'1',NULL,1,'Das Erste','Das Erste','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28106,NULL,0,0,0),   (29108,'28108',NULL,1,'hr-fernsehen','hr-fernsehen','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28108,NULL,0,0,0),(29112,'28112',NULL,1,'BR-alpha','BR-alpha','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28112,NULL,0,0,0),(29113,'28113',NULL,1,'SÃœDWEST Ferns. BW','SÃœDWEST Ferns. BW','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28113,NULL,0,0,0),(29114,'28114',NULL,1,'Phoenix','Phoenix','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,27,28114,NULL,0,0,0),(29007,'28007',NULL,1,'3sat','3sat','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28007,NULL,0,0,0),(29012,'28012',NULL,1,'DKULTUR','DKULTUR','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28012,NULL,0,0,0),(29013,'28013',NULL,1,'DLF','DLF','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28013,NULL,0,0,0),(29008,'28008',NULL,1,'KiKa','KiKa','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28008,NULL,0,0,0),
(29006,'2',NULL,1,'ZDF','ZDF','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28006,NULL,0,0,0),               (29014,'28014',NULL,1,'ZDFdokukanal','ZDFdokukanal','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28014,NULL,0,0,0),(29011,'28011',NULL,1,'ZDFinfokanal','ZDFinfokanal','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28011,NULL,0,0,0),(29016,'28016',NULL,1,'ZDFtheaterkanal','ZDFtheaterkanal','',NULL,'','',0,32768,32768,32768,32768,'Default',0,1,'',1,28,28016,NULL,0,0,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `channel` ENABLE KEYS */;

--
-- Table structure for table `codecparams`
--

DROP TABLE IF EXISTS `codecparams`;
CREATE TABLE `codecparams` (
  `profile` int(10) unsigned NOT NULL default '0',
  `name` varchar(128) NOT NULL default '',
  `value` varchar(128) default NULL,
  PRIMARY KEY  (`profile`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `codecparams`
--


/*!40000 ALTER TABLE `codecparams` DISABLE KEYS */;
LOCK TABLES `codecparams` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `codecparams` ENABLE KEYS */;

--
-- Table structure for table `credits`
--

DROP TABLE IF EXISTS `credits`;
CREATE TABLE `credits` (
  `person` mediumint(8) unsigned NOT NULL default '0',
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `role` set('actor','director','producer','executive_producer','writer','guest_star','host','adapter','presenter','commentator','guest') NOT NULL default '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`person`,`role`),
  KEY `person` (`person`,`role`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `credits`
--


/*!40000 ALTER TABLE `credits` DISABLE KEYS */;
LOCK TABLES `credits` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `credits` ENABLE KEYS */;

--
-- Table structure for table `customexample`
--

DROP TABLE IF EXISTS `customexample`;
CREATE TABLE `customexample` (
  `rulename` varchar(64) NOT NULL,
  `fromclause` text NOT NULL,
  `whereclause` text NOT NULL,
  PRIMARY KEY  (`rulename`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `customexample`
--


/*!40000 ALTER TABLE `customexample` DISABLE KEYS */;
LOCK TABLES `customexample` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `customexample` ENABLE KEYS */;

--
-- Table structure for table `diseqc_config`
--

DROP TABLE IF EXISTS `diseqc_config`;
CREATE TABLE `diseqc_config` (
  `cardinputid` int(10) unsigned NOT NULL,
  `diseqcid` int(10) unsigned NOT NULL,
  `value` varchar(16) NOT NULL default '',
  KEY `id` (`cardinputid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `diseqc_config`
--


/*!40000 ALTER TABLE `diseqc_config` DISABLE KEYS */;
LOCK TABLES `diseqc_config` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `diseqc_config` ENABLE KEYS */;

--
-- Table structure for table `diseqc_tree`
--

DROP TABLE IF EXISTS `diseqc_tree`;
CREATE TABLE `diseqc_tree` (
  `diseqcid` int(10) unsigned NOT NULL auto_increment,
  `parentid` int(10) unsigned default NULL,
  `ordinal` tinyint(3) unsigned NOT NULL,
  `type` varchar(16) NOT NULL default '',
  `subtype` varchar(16) NOT NULL default '',
  `description` varchar(32) NOT NULL default '',
  `switch_ports` tinyint(3) unsigned NOT NULL default '0',
  `rotor_hi_speed` float NOT NULL default '0',
  `rotor_lo_speed` float NOT NULL default '0',
  `rotor_positions` varchar(255) NOT NULL default '',
  `lnb_lof_switch` int(10) NOT NULL default '0',
  `lnb_lof_hi` int(10) NOT NULL default '0',
  `lnb_lof_lo` int(10) NOT NULL default '0',
  PRIMARY KEY  (`diseqcid`),
  KEY `parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `diseqc_tree`
--


/*!40000 ALTER TABLE `diseqc_tree` DISABLE KEYS */;
LOCK TABLES `diseqc_tree` WRITE;
INSERT INTO `diseqc_tree` VALUES (1,NULL,0,'lnb','voltage_tone','LNB',0,0,0,'',11700000,10600000,9750000);
UNLOCK TABLES;
/*!40000 ALTER TABLE `diseqc_tree` ENABLE KEYS */;

--
-- Table structure for table `dtv_multiplex`
--

DROP TABLE IF EXISTS `dtv_multiplex`;
CREATE TABLE `dtv_multiplex` (
  `mplexid` smallint(6) NOT NULL auto_increment,
  `sourceid` smallint(6) default NULL,
  `transportid` int(11) default NULL,
  `networkid` int(11) default NULL,
  `frequency` int(11) default NULL,
  `inversion` char(1) default 'a',
  `symbolrate` int(11) default NULL,
  `fec` varchar(10) default 'auto',
  `polarity` char(1) default NULL,
  `modulation` varchar(10) default 'auto',
  `bandwidth` char(1) default 'a',
  `lp_code_rate` varchar(10) default 'auto',
  `transmission_mode` char(1) default 'a',
  `guard_interval` varchar(10) default 'auto',
  `visible` smallint(1) NOT NULL default '0',
  `constellation` varchar(10) default 'auto',
  `hierarchy` varchar(10) default 'auto',
  `hp_code_rate` varchar(10) default 'auto',
  `sistandard` varchar(10) default 'dvb',
  `serviceversion` smallint(6) default '33',
  `updatetimestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`mplexid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dtv_multiplex`
--


/*!40000 ALTER TABLE `dtv_multiplex` DISABLE KEYS */;
LOCK TABLES `dtv_multiplex` WRITE;
INSERT INTO `dtv_multiplex` VALUES (1,1,1114,1,12640000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:33'),(2,1,1032,1,11685500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:33'),(3,1,1110,1,12581000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:33'),(4,1,1273,1,11875500,'a',27500000,'3/4','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:33'),(5,1,1034,1,10979000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:33'),(6,1,1060,1,10876500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(7,1,1107,1,12544750,'a',22000000,'5/6','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(8,1,1053,1,10773250,'a',22000000,'5/6','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(9,1,1072,1,11856000,'a',27500000,'3/4','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(10,1,1042,1,11097000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(11,1,1054,1,10788000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(12,1,1020,1,11508500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(13,1,1058,1,10847000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(14,1,1056,1,10817500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(15,1,1115,1,12662750,'a',22000000,'5/6','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(16,1,1063,1,10920750,'a',22000000,'5/6','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(17,1,1018,1,11479000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(18,1,1120,1,12728500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(19,1,1093,1,12265500,'a',27500000,'3/4','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(20,1,1088,1,12168000,'a',27500000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(21,1,1031,1,11670750,'a',22000000,'5/6','h','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(22,1,1106,1,12522000,'a',22000000,'2/3','v','auto',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(23,1,6,133,11914500,'a',27500000,'auto','h','auto',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(24,1,1022,1,11538000,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(25,1,1102,1,12441000,'a',27500000,'3/4','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),(26,1,1112,1,12610500,'a',22000000,'5/6','v','qpsk',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',33,'2006-08-11 10:48:34'),
(27,1,1101,1,1238037,NULL,NULL,NULL,NULL,'auto',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',19,'2006-08-11 10:48:34'),
(28,1,1079,1,1355029,NULL,NULL,NULL,NULL,'auto',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'dvb',3,'2006-08-11 10:49:03');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dtv_multiplex` ENABLE KEYS */;

--
-- Table structure for table `dtv_privatetypes`
--

DROP TABLE IF EXISTS `dtv_privatetypes`;
CREATE TABLE `dtv_privatetypes` (
  `sitype` varchar(4) NOT NULL default '',
  `networkid` int(11) NOT NULL default '0',
  `private_type` varchar(20) NOT NULL default '',
  `private_value` varchar(100) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dtv_privatetypes`
--


/*!40000 ALTER TABLE `dtv_privatetypes` DISABLE KEYS */;
LOCK TABLES `dtv_privatetypes` WRITE;
INSERT INTO `dtv_privatetypes` VALUES ('dvb',9018,'channel_numbers','131'),('dvb',9018,'guide_fixup','2'),('dvb',256,'guide_fixup','1'),('dvb',257,'guide_fixup','1'),('dvb',256,'tv_types','1,150,134,133'),('dvb',257,'tv_types','1,150,134,133'),('dvb',4100,'sdt_mapping','1'),('dvb',4101,'sdt_mapping','1'),('dvb',4102,'sdt_mapping','1'),('dvb',4103,'sdt_mapping','1'),('dvb',4104,'sdt_mapping','1'),('dvb',4105,'sdt_mapping','1'),('dvb',4106,'sdt_mapping','1'),('dvb',4107,'sdt_mapping','1'),('dvb',4097,'sdt_mapping','1'),('dvb',4098,'sdt_mapping','1'),('dvb',4100,'tv_types','1,145,154'),('dvb',4101,'tv_types','1,145,154'),('dvb',4102,'tv_types','1,145,154'),('dvb',4103,'tv_types','1,145,154'),('dvb',4104,'tv_types','1,145,154'),('dvb',4105,'tv_types','1,145,154'),('dvb',4106,'tv_types','1,145,154'),('dvb',4107,'tv_types','1,145,154'),('dvb',4097,'tv_types','1,145,154'),('dvb',4098,'tv_types','1,145,154'),('dvb',4100,'guide_fixup','1'),('dvb',4101,'guide_fixup','1'),('dvb',4102,'guide_fixup','1'),('dvb',4103,'guide_fixup','1'),('dvb',4104,'guide_fixup','1'),('dvb',4105,'guide_fixup','1'),('dvb',4106,'guide_fixup','1'),('dvb',4107,'guide_fixup','1'),('dvb',4096,'guide_fixup','5'),('dvb',4097,'guide_fixup','1'),('dvb',4098,'guide_fixup','1'),('dvb',94,'tv_types','1,128'),('atsc',1793,'guide_fixup','3'),('dvb',40999,'guide_fixup','4'),('dvb',70,'force_guide_present','yes'),('dvb',70,'guide_ranges','80,80,96,96'),('dvb',4112,'channel_numbers','131'),('dvb',4115,'channel_numbers','131'),('dvb',4116,'channel_numbers','131'),('dvb',12802,'channel_numbers','131'),('dvb',12803,'channel_numbers','131'),('dvb',12829,'channel_numbers','131'),('dvb',40999,'parse_subtitle_list','1070,1308,1041,1306,1307,1030,1016,1131,1068,1069'),('dvb',4096,'guide_fixup','5');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dtv_privatetypes` ENABLE KEYS */;

--
-- Table structure for table `eit_cache`
--

DROP TABLE IF EXISTS `eit_cache`;
CREATE TABLE `eit_cache` (
  `chanid` int(10) NOT NULL,
  `eventid` smallint(5) unsigned NOT NULL,
  `tableid` tinyint(3) unsigned NOT NULL,
  `version` tinyint(3) unsigned NOT NULL,
  `endtime` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`chanid`,`eventid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `eit_cache`
--


/*!40000 ALTER TABLE `eit_cache` DISABLE KEYS */;
LOCK TABLES `eit_cache` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `eit_cache` ENABLE KEYS */;

--
-- Table structure for table `favorites`
--

DROP TABLE IF EXISTS `favorites`;
CREATE TABLE `favorites` (
  `favid` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `chanid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`favid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `favorites`
--


/*!40000 ALTER TABLE `favorites` DISABLE KEYS */;
LOCK TABLES `favorites` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `favorites` ENABLE KEYS */;

--
-- Table structure for table `housekeeping`
--

DROP TABLE IF EXISTS `housekeeping`;
CREATE TABLE `housekeeping` (
  `tag` varchar(64) NOT NULL default '',
  `lastrun` datetime default NULL,
  PRIMARY KEY  (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `housekeeping`
--


/*!40000 ALTER TABLE `housekeeping` DISABLE KEYS */;
LOCK TABLES `housekeeping` WRITE;
INSERT INTO `housekeeping` VALUES ('JobQueueCleanup','2006-08-11 12:53:38'),('InUseProgramsCleanup','2006-08-11 12:53:38'),('JobQueueRecover-zenslack','2006-08-11 12:53:38');
UNLOCK TABLES;
/*!40000 ALTER TABLE `housekeeping` ENABLE KEYS */;

--
-- Table structure for table `inuseprograms`
--

DROP TABLE IF EXISTS `inuseprograms`;
CREATE TABLE `inuseprograms` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `recusage` varchar(128) NOT NULL default '',
  `lastupdatetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `hostname` varchar(255) NOT NULL default '',
  KEY `chanid` (`chanid`,`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inuseprograms`
--


/*!40000 ALTER TABLE `inuseprograms` DISABLE KEYS */;
LOCK TABLES `inuseprograms` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `inuseprograms` ENABLE KEYS */;

--
-- Table structure for table `jobqueue`
--

DROP TABLE IF EXISTS `jobqueue`;
CREATE TABLE `jobqueue` (
  `id` int(11) NOT NULL auto_increment,
  `chanid` int(10) NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `inserttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` int(11) NOT NULL default '0',
  `cmds` int(11) NOT NULL default '0',
  `flags` int(11) NOT NULL default '0',
  `status` int(11) NOT NULL default '0',
  `statustime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `hostname` varchar(255) NOT NULL default '',
  `args` blob NOT NULL,
  `comment` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`type`,`inserttime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `jobqueue`
--


/*!40000 ALTER TABLE `jobqueue` DISABLE KEYS */;
LOCK TABLES `jobqueue` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `jobqueue` ENABLE KEYS */;

--
-- Table structure for table `jumppoints`
--

DROP TABLE IF EXISTS `jumppoints`;
CREATE TABLE `jumppoints` (
  `destination` varchar(128) NOT NULL default '',
  `description` varchar(255) default NULL,
  `keylist` varchar(128) default NULL,
  `hostname` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`destination`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `jumppoints`
--


/*!40000 ALTER TABLE `jumppoints` DISABLE KEYS */;
LOCK TABLES `jumppoints` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `jumppoints` ENABLE KEYS */;

--
-- Table structure for table `keybindings`
--

DROP TABLE IF EXISTS `keybindings`;
CREATE TABLE `keybindings` (
  `context` varchar(32) NOT NULL default '',
  `action` varchar(32) NOT NULL default '',
  `description` varchar(255) default NULL,
  `keylist` varchar(128) default NULL,
  `hostname` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`context`,`action`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `keybindings`
--


/*!40000 ALTER TABLE `keybindings` DISABLE KEYS */;
LOCK TABLES `keybindings` WRITE;
INSERT INTO `keybindings` VALUES ('Global','UP','Up Arrow','Up','zenslack'),('Global','DOWN','Down Arrow','Down','zenslack'),('Global','LEFT','Left Arrow','Left','zenslack'),('Global','RIGHT','Right Arrow','Right','zenslack'),('Global','SELECT','Select','Return,Enter,Space','zenslack'),('Global','ESCAPE','Escape','Esc','zenslack'),('Global','MENU','Pop-up menu','M','zenslack'),('Global','INFO','More information','I','zenslack'),('Global','PAGEUP','Page Up','PgUp','zenslack'),('Global','PAGEDOWN','Page Down','PgDown','zenslack'),('Global','PREVVIEW','Previous View','Home','zenslack'),('Global','NEXTVIEW','Next View','End','zenslack'),('Global','HELP','Help','F1','zenslack'),('Global','EJECT','Eject Removable Media','','zenslack'),('Global','0','0','0','zenslack'),('Global','1','1','1','zenslack'),('Global','2','2','2','zenslack'),('Global','3','3','3','zenslack'),('Global','4','4','4','zenslack'),('Global','5','5','5','zenslack'),('Global','6','6','6','zenslack'),('Global','7','7','7','zenslack'),('Global','8','8','8','zenslack'),('Global','9','9','9','zenslack'),('qt','DELETE','Delete','D','zenslack'),('qt','EDIT','Edit','E','zenslack');
UNLOCK TABLES;
/*!40000 ALTER TABLE `keybindings` ENABLE KEYS */;

--
-- Table structure for table `keyword`
--

DROP TABLE IF EXISTS `keyword`;
CREATE TABLE `keyword` (
  `phrase` varchar(128) NOT NULL default '',
  `searchtype` int(10) unsigned NOT NULL default '3',
  UNIQUE KEY `phrase` (`phrase`,`searchtype`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `keyword`
--


/*!40000 ALTER TABLE `keyword` DISABLE KEYS */;
LOCK TABLES `keyword` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `keyword` ENABLE KEYS */;

--
-- Table structure for table `mythlog`
--

DROP TABLE IF EXISTS `mythlog`;
CREATE TABLE `mythlog` (
  `logid` int(10) unsigned NOT NULL auto_increment,
  `module` varchar(32) NOT NULL default '',
  `priority` int(11) NOT NULL default '0',
  `acknowledged` tinyint(1) default '0',
  `logdate` datetime default NULL,
  `host` varchar(128) default NULL,
  `message` varchar(255) NOT NULL default '',
  `details` text,
  PRIMARY KEY  (`logid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mythlog`
--


/*!40000 ALTER TABLE `mythlog` DISABLE KEYS */;
LOCK TABLES `mythlog` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `mythlog` ENABLE KEYS */;

--
-- Table structure for table `networkiconmap`
--

DROP TABLE IF EXISTS `networkiconmap`;
CREATE TABLE `networkiconmap` (
  `id` int(11) NOT NULL auto_increment,
  `network` varchar(20) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `network` (`network`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `networkiconmap`
--


/*!40000 ALTER TABLE `networkiconmap` DISABLE KEYS */;
LOCK TABLES `networkiconmap` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `networkiconmap` ENABLE KEYS */;

--
-- Table structure for table `oldfind`
--

DROP TABLE IF EXISTS `oldfind`;
CREATE TABLE `oldfind` (
  `recordid` int(11) NOT NULL default '0',
  `findid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`recordid`,`findid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `oldfind`
--


/*!40000 ALTER TABLE `oldfind` DISABLE KEYS */;
LOCK TABLES `oldfind` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `oldfind` ENABLE KEYS */;

--
-- Table structure for table `oldprogram`
--

DROP TABLE IF EXISTS `oldprogram`;
CREATE TABLE `oldprogram` (
  `oldtitle` varchar(128) NOT NULL default '',
  `airdate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`oldtitle`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `oldprogram`
--


/*!40000 ALTER TABLE `oldprogram` DISABLE KEYS */;
LOCK TABLES `oldprogram` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `oldprogram` ENABLE KEYS */;

--
-- Table structure for table `oldrecorded`
--

DROP TABLE IF EXISTS `oldrecorded`;
CREATE TABLE `oldrecorded` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL default '',
  `subtitle` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL default '',
  `seriesid` varchar(12) NOT NULL default '',
  `programid` varchar(20) NOT NULL default '',
  `findid` int(11) NOT NULL default '0',
  `recordid` int(11) NOT NULL default '0',
  `station` varchar(20) NOT NULL default '',
  `rectype` int(10) unsigned NOT NULL default '0',
  `duplicate` tinyint(1) NOT NULL default '0',
  `recstatus` int(11) NOT NULL default '0',
  `reactivate` smallint(6) NOT NULL default '0',
  `generic` tinyint(1) default '0',
  PRIMARY KEY  (`station`,`starttime`,`title`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `recordid` (`recordid`),
  KEY `recstatus` (`recstatus`,`programid`,`seriesid`),
  KEY `recstatus_2` (`recstatus`,`title`,`subtitle`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `oldrecorded`
--


/*!40000 ALTER TABLE `oldrecorded` DISABLE KEYS */;
LOCK TABLES `oldrecorded` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `oldrecorded` ENABLE KEYS */;

--
-- Table structure for table `people`
--

DROP TABLE IF EXISTS `people`;
CREATE TABLE `people` (
  `person` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(128) NOT NULL default '',
  PRIMARY KEY  (`person`),
  UNIQUE KEY `name` (`name`(41))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `people`
--


/*!40000 ALTER TABLE `people` DISABLE KEYS */;
LOCK TABLES `people` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `people` ENABLE KEYS */;

--
-- Table structure for table `pidcache`
--

DROP TABLE IF EXISTS `pidcache`;
CREATE TABLE `pidcache` (
  `chanid` smallint(6) NOT NULL default '0',
  `pid` int(11) NOT NULL default '-1',
  `tableid` int(11) NOT NULL default '-1',
  KEY `chanid` (`chanid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `pidcache`
--


/*!40000 ALTER TABLE `pidcache` DISABLE KEYS */;
LOCK TABLES `pidcache` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `pidcache` ENABLE KEYS */;

--
-- Table structure for table `playgroup`
--

DROP TABLE IF EXISTS `playgroup`;
CREATE TABLE `playgroup` (
  `name` varchar(32) NOT NULL default '',
  `titlematch` varchar(255) NOT NULL default '',
  `skipahead` int(11) NOT NULL default '0',
  `skipback` int(11) NOT NULL default '0',
  `timestretch` int(11) NOT NULL default '0',
  `jump` int(11) NOT NULL default '0',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `playgroup`
--


/*!40000 ALTER TABLE `playgroup` DISABLE KEYS */;
LOCK TABLES `playgroup` WRITE;
INSERT INTO `playgroup` VALUES ('Default','',30,5,100,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `playgroup` ENABLE KEYS */;

--
-- Table structure for table `profilegroups`
--

DROP TABLE IF EXISTS `profilegroups`;
CREATE TABLE `profilegroups` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(128) default NULL,
  `cardtype` varchar(32) NOT NULL default 'V4L',
  `is_default` int(1) default '0',
  `hostname` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `profilegroups`
--


/*!40000 ALTER TABLE `profilegroups` DISABLE KEYS */;
LOCK TABLES `profilegroups` WRITE;
INSERT INTO `profilegroups` VALUES (1,'Software Encoders (v4l based)','V4L',1,NULL),(2,'MPEG-2 Encoders (PVR-x50, PVR-500)','MPEG',1,NULL),(3,'Hardware MJPEG Encoders (Matrox G200-TV, Miro DC10, etc)','MJPEG',1,NULL),(4,'Hardware HDTV','HDTV',1,NULL),(5,'Hardware DVB Encoders','DVB',1,NULL),(6,'Transcoders','TRANSCODE',1,NULL),(7,'FireWire Input','FIREWIRE',1,NULL),(8,'USB Mpeg-4 Encoder (Plextor ConvertX, etc)','GO7007',1,NULL),(9,'DBOX2 Input','DBOX2',1,NULL),(10,'Freebox Input','Freebox',1,NULL),(11,'HDHomeRun Recorders','HDHOMERUN',1,NULL),(12,'CRC IP Recorders','CRC_IP',1,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `profilegroups` ENABLE KEYS */;

--
-- Table structure for table `program`
--

DROP TABLE IF EXISTS `program`;
CREATE TABLE `program` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL default '',
  `subtitle` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL default '',
  `category_type` varchar(64) NOT NULL default '',
  `airdate` year(4) NOT NULL default '0000',
  `stars` float NOT NULL default '0',
  `previouslyshown` tinyint(4) NOT NULL default '0',
  `title_pronounce` varchar(128) NOT NULL default '',
  `stereo` tinyint(1) NOT NULL default '0',
  `subtitled` tinyint(1) NOT NULL default '0',
  `hdtv` tinyint(1) NOT NULL default '0',
  `closecaptioned` tinyint(1) NOT NULL default '0',
  `partnumber` int(11) NOT NULL default '0',
  `parttotal` int(11) NOT NULL default '0',
  `seriesid` varchar(12) NOT NULL default '',
  `originalairdate` date default NULL,
  `showtype` varchar(30) NOT NULL default '',
  `colorcode` varchar(20) NOT NULL default '',
  `syndicatedepisodenumber` varchar(20) NOT NULL default '',
  `programid` varchar(20) NOT NULL default '',
  `manualid` int(10) unsigned NOT NULL default '0',
  `generic` tinyint(1) default '0',
  `listingsource` int(11) NOT NULL default '0',
  `first` tinyint(1) NOT NULL default '0',
  `last` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`chanid`,`starttime`,`manualid`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `title_pronounce` (`title_pronounce`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `id_start_end` (`chanid`,`starttime`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `program`
--


/*!40000 ALTER TABLE `program` DISABLE KEYS */;
LOCK TABLES `program` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `program` ENABLE KEYS */;

--
-- Table structure for table `programgenres`
--

DROP TABLE IF EXISTS `programgenres`;
CREATE TABLE `programgenres` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `relevance` char(1) NOT NULL default '',
  `genre` char(30) default NULL,
  PRIMARY KEY  (`chanid`,`starttime`,`relevance`),
  KEY `genre` (`genre`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `programgenres`
--


/*!40000 ALTER TABLE `programgenres` DISABLE KEYS */;
LOCK TABLES `programgenres` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `programgenres` ENABLE KEYS */;

--
-- Table structure for table `programrating`
--

DROP TABLE IF EXISTS `programrating`;
CREATE TABLE `programrating` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `system` char(8) NOT NULL default '',
  `rating` char(8) NOT NULL default '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`system`,`rating`),
  KEY `starttime` (`starttime`,`system`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `programrating`
--


/*!40000 ALTER TABLE `programrating` DISABLE KEYS */;
LOCK TABLES `programrating` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `programrating` ENABLE KEYS */;

--
-- Table structure for table `recgrouppassword`
--

DROP TABLE IF EXISTS `recgrouppassword`;
CREATE TABLE `recgrouppassword` (
  `recgroup` varchar(32) NOT NULL default '',
  `password` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`recgroup`),
  UNIQUE KEY `recgroup` (`recgroup`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recgrouppassword`
--


/*!40000 ALTER TABLE `recgrouppassword` DISABLE KEYS */;
LOCK TABLES `recgrouppassword` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recgrouppassword` ENABLE KEYS */;

--
-- Table structure for table `record`
--

DROP TABLE IF EXISTS `record`;
CREATE TABLE `record` (
  `recordid` int(10) unsigned NOT NULL auto_increment,
  `type` int(10) unsigned NOT NULL default '0',
  `chanid` int(10) unsigned default NULL,
  `starttime` time NOT NULL default '00:00:00',
  `startdate` date NOT NULL default '0000-00-00',
  `endtime` time NOT NULL default '00:00:00',
  `enddate` date NOT NULL default '0000-00-00',
  `title` varchar(128) NOT NULL default '',
  `subtitle` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL default '',
  `profile` varchar(128) NOT NULL default 'Default',
  `recpriority` int(10) NOT NULL default '0',
  `autoexpire` int(11) NOT NULL default '0',
  `maxepisodes` int(11) NOT NULL default '0',
  `maxnewest` int(11) NOT NULL default '0',
  `startoffset` int(11) NOT NULL default '0',
  `endoffset` int(11) NOT NULL default '0',
  `recgroup` varchar(32) NOT NULL default 'Default',
  `dupmethod` int(11) NOT NULL default '6',
  `dupin` int(11) NOT NULL default '15',
  `station` varchar(20) NOT NULL default '',
  `seriesid` varchar(12) NOT NULL default '',
  `programid` varchar(20) NOT NULL default '',
  `search` int(10) unsigned NOT NULL default '0',
  `autotranscode` tinyint(1) NOT NULL default '0',
  `autocommflag` tinyint(1) NOT NULL default '0',
  `autouserjob1` tinyint(1) NOT NULL default '0',
  `autouserjob2` tinyint(1) NOT NULL default '0',
  `autouserjob3` tinyint(1) NOT NULL default '0',
  `autouserjob4` tinyint(1) NOT NULL default '0',
  `findday` tinyint(4) NOT NULL default '0',
  `findtime` time NOT NULL default '00:00:00',
  `findid` int(11) NOT NULL default '0',
  `inactive` tinyint(1) NOT NULL default '0',
  `parentid` int(11) NOT NULL default '0',
  `transcoder` int(11) NOT NULL default '0',
  `tsdefault` float NOT NULL default '1',
  `playgroup` varchar(32) NOT NULL default 'Default',
  `prefinput` int(10) NOT NULL default '0',
  PRIMARY KEY  (`recordid`),
  KEY `chanid` (`chanid`,`starttime`),
  KEY `title` (`title`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `record`
--


/*!40000 ALTER TABLE `record` DISABLE KEYS */;
LOCK TABLES `record` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `record` ENABLE KEYS */;

--
-- Table structure for table `recorded`
--

DROP TABLE IF EXISTS `recorded`;
CREATE TABLE `recorded` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL default '',
  `subtitle` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL default '',
  `hostname` varchar(255) NOT NULL default '',
  `bookmark` tinyint(1) NOT NULL default '0',
  `editing` int(10) unsigned NOT NULL default '0',
  `cutlist` tinyint(1) NOT NULL default '0',
  `autoexpire` int(11) NOT NULL default '0',
  `commflagged` int(10) unsigned NOT NULL default '0',
  `recgroup` varchar(32) NOT NULL default 'Default',
  `recordid` int(11) default NULL,
  `seriesid` varchar(12) NOT NULL default '',
  `programid` varchar(20) NOT NULL default '',
  `lastmodified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `filesize` bigint(20) NOT NULL default '0',
  `stars` float NOT NULL default '0',
  `previouslyshown` tinyint(1) default '0',
  `originalairdate` date default NULL,
  `preserve` tinyint(1) NOT NULL default '0',
  `findid` int(11) NOT NULL default '0',
  `deletepending` tinyint(1) NOT NULL default '0',
  `transcoder` int(11) NOT NULL default '0',
  `timestretch` float NOT NULL default '1',
  `recpriority` int(11) NOT NULL default '0',
  `basename` varchar(128) NOT NULL default '',
  `progstart` datetime NOT NULL default '0000-00-00 00:00:00',
  `progend` datetime NOT NULL default '0000-00-00 00:00:00',
  `playgroup` varchar(32) NOT NULL default 'Default',
  `profile` varchar(32) NOT NULL default '',
  `duplicate` tinyint(1) NOT NULL default '0',
  `transcoded` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`chanid`,`starttime`),
  KEY `endtime` (`endtime`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `title` (`title`),
  KEY `recordid` (`recordid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recorded`
--


/*!40000 ALTER TABLE `recorded` DISABLE KEYS */;
LOCK TABLES `recorded` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recorded` ENABLE KEYS */;

--
-- Table structure for table `recordedcredits`
--

DROP TABLE IF EXISTS `recordedcredits`;
CREATE TABLE `recordedcredits` (
  `person` mediumint(8) unsigned NOT NULL default '0',
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `role` set('actor','director','producer','executive_producer','writer','guest_star','host','adapter','presenter','commentator','guest') NOT NULL default '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`person`,`role`),
  KEY `person` (`person`,`role`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordedcredits`
--


/*!40000 ALTER TABLE `recordedcredits` DISABLE KEYS */;
LOCK TABLES `recordedcredits` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordedcredits` ENABLE KEYS */;

--
-- Table structure for table `recordedmarkup`
--

DROP TABLE IF EXISTS `recordedmarkup`;
CREATE TABLE `recordedmarkup` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mark` bigint(20) NOT NULL default '0',
  `offset` varchar(32) default NULL,
  `type` int(11) NOT NULL default '0',
  PRIMARY KEY  (`chanid`,`starttime`,`type`,`mark`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordedmarkup`
--


/*!40000 ALTER TABLE `recordedmarkup` DISABLE KEYS */;
LOCK TABLES `recordedmarkup` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordedmarkup` ENABLE KEYS */;

--
-- Table structure for table `recordedprogram`
--

DROP TABLE IF EXISTS `recordedprogram`;
CREATE TABLE `recordedprogram` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL default '',
  `subtitle` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL default '',
  `category_type` varchar(64) NOT NULL default '',
  `airdate` year(4) NOT NULL default '0000',
  `stars` float unsigned NOT NULL default '0',
  `previouslyshown` tinyint(4) NOT NULL default '0',
  `title_pronounce` varchar(128) NOT NULL default '',
  `stereo` tinyint(1) NOT NULL default '0',
  `subtitled` tinyint(1) NOT NULL default '0',
  `hdtv` tinyint(1) NOT NULL default '0',
  `closecaptioned` tinyint(1) NOT NULL default '0',
  `partnumber` int(11) NOT NULL default '0',
  `parttotal` int(11) NOT NULL default '0',
  `seriesid` varchar(12) NOT NULL default '',
  `originalairdate` date default NULL,
  `showtype` varchar(30) NOT NULL default '',
  `colorcode` varchar(20) NOT NULL default '',
  `syndicatedepisodenumber` varchar(20) NOT NULL default '',
  `programid` varchar(20) NOT NULL default '',
  `manualid` int(10) unsigned NOT NULL default '0',
  `generic` tinyint(1) default '0',
  `listingsource` int(11) NOT NULL default '0',
  `first` tinyint(1) NOT NULL default '0',
  `last` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`chanid`,`starttime`,`manualid`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `title_pronounce` (`title_pronounce`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `id_start_end` (`chanid`,`starttime`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordedprogram`
--


/*!40000 ALTER TABLE `recordedprogram` DISABLE KEYS */;
LOCK TABLES `recordedprogram` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordedprogram` ENABLE KEYS */;

--
-- Table structure for table `recordedrating`
--

DROP TABLE IF EXISTS `recordedrating`;
CREATE TABLE `recordedrating` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `system` char(8) NOT NULL default '',
  `rating` char(8) NOT NULL default '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`system`,`rating`),
  KEY `starttime` (`starttime`,`system`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordedrating`
--


/*!40000 ALTER TABLE `recordedrating` DISABLE KEYS */;
LOCK TABLES `recordedrating` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordedrating` ENABLE KEYS */;

--
-- Table structure for table `recordedseek`
--

DROP TABLE IF EXISTS `recordedseek`;
CREATE TABLE `recordedseek` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mark` bigint(20) NOT NULL default '0',
  `offset` varchar(32) default NULL,
  `type` int(11) NOT NULL default '0',
  PRIMARY KEY  (`chanid`,`starttime`,`type`,`mark`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordedseek`
--


/*!40000 ALTER TABLE `recordedseek` DISABLE KEYS */;
LOCK TABLES `recordedseek` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordedseek` ENABLE KEYS */;

--
-- Table structure for table `recordingprofiles`
--

DROP TABLE IF EXISTS `recordingprofiles`;
CREATE TABLE `recordingprofiles` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(128) default NULL,
  `videocodec` varchar(128) default NULL,
  `audiocodec` varchar(128) default NULL,
  `profilegroup` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordingprofiles`
--


/*!40000 ALTER TABLE `recordingprofiles` DISABLE KEYS */;
LOCK TABLES `recordingprofiles` WRITE;
INSERT INTO `recordingprofiles` VALUES (1,'Default',NULL,NULL,1),(2,'Live TV',NULL,NULL,1),(3,'High Quality',NULL,NULL,1),(4,'Low Quality',NULL,NULL,1),(5,'Default',NULL,NULL,2),(6,'Live TV',NULL,NULL,2),(7,'High Quality',NULL,NULL,2),(8,'Low Quality',NULL,NULL,2),(9,'Default',NULL,NULL,3),(10,'Live TV',NULL,NULL,3),(11,'High Quality',NULL,NULL,3),(12,'Low Quality',NULL,NULL,3),(13,'Default',NULL,NULL,4),(14,'Live TV',NULL,NULL,4),(15,'High Quality',NULL,NULL,4),(16,'Low Quality',NULL,NULL,4),(17,'Default',NULL,NULL,5),(18,'Live TV',NULL,NULL,5),(19,'High Quality',NULL,NULL,5),(20,'Low Quality',NULL,NULL,5),(21,'RTjpeg/MPEG4',NULL,NULL,6),(22,'MPEG2',NULL,NULL,6),(23,'Default',NULL,NULL,8),(24,'Live TV',NULL,NULL,8),(25,'High Quality',NULL,NULL,8),(26,'Low Quality',NULL,NULL,8),(27,'High Quality',NULL,NULL,6),(28,'Medium Quality',NULL,NULL,6),(29,'Low Quality',NULL,NULL,6),(30,'Default',NULL,NULL,10),(31,'Live TV',NULL,NULL,10),(32,'High Quality',NULL,NULL,10),(33,'Low Quality',NULL,NULL,10),(34,'Default',NULL,NULL,11),(35,'Live TV',NULL,NULL,11),(36,'High Quality',NULL,NULL,11),(37,'Low Quality',NULL,NULL,11),(38,'Default',NULL,NULL,12),(39,'Live TV',NULL,NULL,12),(40,'High Quality',NULL,NULL,12),(41,'Low Quality',NULL,NULL,12);
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordingprofiles` ENABLE KEYS */;

--
-- Table structure for table `recordmatch`
--

DROP TABLE IF EXISTS `recordmatch`;
CREATE TABLE `recordmatch` (
  `recordid` int(10) unsigned default NULL,
  `chanid` int(10) unsigned default NULL,
  `starttime` datetime default NULL,
  `manualid` int(10) unsigned default NULL,
  KEY `recordid` (`recordid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `recordmatch`
--


/*!40000 ALTER TABLE `recordmatch` DISABLE KEYS */;
LOCK TABLES `recordmatch` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `recordmatch` ENABLE KEYS */;

--
-- Table structure for table `schemalock`
--

DROP TABLE IF EXISTS `schemalock`;
CREATE TABLE `schemalock` (
  `schemalock` int(1) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `schemalock`
--


/*!40000 ALTER TABLE `schemalock` DISABLE KEYS */;
LOCK TABLES `schemalock` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `schemalock` ENABLE KEYS */;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `value` varchar(128) NOT NULL default '',
  `data` text,
  `hostname` varchar(255) default NULL,
  KEY `value` (`value`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `settings`
--


/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
LOCK TABLES `settings` WRITE;
INSERT INTO `settings` VALUES ('mythfilldatabaseLastRunStart',NULL,NULL),('mythfilldatabaseLastRunEnd',NULL,NULL),('mythfilldatabaseLastRunStatus',NULL,NULL),('DataDirectMessage',NULL,NULL),('HaveRepeats','0',NULL),('DBSchemaVer','1155',NULL),('DefaultTranscoder','0',NULL),('MythFillSuggestedRunTime','1970-01-01T00:00:00',NULL),('MythFillGrabberSuggestsTime','1',NULL),('Language','DE','zenslack'),('BackendServerIP','127.0.0.1','zenslack'),('BackendServerPort','6543','zenslack'),('BackendStatusPort','6544','zenslack'),('MasterServerIP','127.0.0.1',NULL),('MasterServerPort','6543',NULL),('RecordFilePrefix','/video/store/','zenslack'),('TVFormat','PAL',NULL),('VbiFormat','PAL Teletext',NULL),('FreqTable','europe-west',NULL),('TimeOffset','None',NULL),('MasterBackendOverride','1',NULL),('DeletesFollowLinks','0',NULL),('EITTimeOffset','Auto',NULL),('EITTransportTimeout','5',NULL),('EITIgnoresSource','0',NULL),('EITCrawIdleStart','60',NULL),('startupCommand','',NULL),('blockSDWUwithoutClient','1',NULL),('idleTimeoutSecs','0',NULL),('idleWaitForRecordingTime','15',NULL),('StartupSecsBeforeRecording','120',NULL),('WakeupTimeFormat','hh:mm yyyy-MM-dd',NULL),('SetWakeuptimeCommand','',NULL),('ServerHaltCommand','sudo /sbin/halt -p',NULL),('preSDWUCheckCommand','',NULL),('WOLbackendReconnectWaitTime','0',NULL),('WOLbackendConnectRetry','5',NULL),('WOLbackendCommand','',NULL),('WOLslaveBackendsCommand','',NULL),('JobQueueMaxSimultaneousJobs','1','zenslack'),('JobQueueCheckFrequency','60','zenslack'),('JobQueueWindowStart','00:00','zenslack'),('JobQueueWindowEnd','23:59','zenslack'),('JobQueueCPU','0','zenslack'),('JobAllowCommFlag','1','zenslack'),('JobAllowTranscode','1','zenslack'),('JobAllowUserJob1','0','zenslack'),('JobAllowUserJob2','0','zenslack'),('JobAllowUserJob3','0','zenslack'),('JobAllowUserJob4','0','zenslack'),('JobsRunOnRecordHost','0',NULL),('AutoCommflagWhileRecording','0',NULL),('JobQueueCommFlagCommand','mythcommflag',NULL),('JobQueueTranscodeCommand','mythtranscode',NULL),('AutoTranscodeBeforeAutoCommflag','0',NULL),('SaveTranscoding','0',NULL),('UserJobDesc1','User Job #1',NULL),('UserJob1','',NULL),('UserJobDesc2','User Job #2',NULL),('UserJob2','',NULL),('UserJobDesc3','User Job #3',NULL),('UserJob3','',NULL),('UserJobDesc4','User Job #4',NULL),('UserJob4','',NULL),('upnp:UDN:urn:schemas-upnp-org:device:MediaServer:1','10896a27-7a3d-4e5c-9afb-655f5429d3ef','zenslack');
UNLOCK TABLES;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;

--
-- Table structure for table `tvchain`
--

DROP TABLE IF EXISTS `tvchain`;
CREATE TABLE `tvchain` (
  `chanid` int(10) unsigned NOT NULL default '0',
  `starttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `chainid` varchar(128) NOT NULL default '',
  `chainpos` int(10) NOT NULL default '0',
  `discontinuity` tinyint(1) NOT NULL default '0',
  `watching` int(10) NOT NULL default '0',
  `hostprefix` varchar(128) NOT NULL default '',
  `cardtype` varchar(32) NOT NULL default 'V4L',
  `input` varchar(32) NOT NULL default '',
  `channame` varchar(32) NOT NULL default '',
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`chanid`,`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tvchain`
--


/*!40000 ALTER TABLE `tvchain` DISABLE KEYS */;
LOCK TABLES `tvchain` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `tvchain` ENABLE KEYS */;

--
-- Table structure for table `videobookmarks`
--

DROP TABLE IF EXISTS `videobookmarks`;
CREATE TABLE `videobookmarks` (
  `filename` varchar(255) NOT NULL default '',
  `bookmark` varchar(128) default NULL,
  PRIMARY KEY  (`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `videobookmarks`
--


/*!40000 ALTER TABLE `videobookmarks` DISABLE KEYS */;
LOCK TABLES `videobookmarks` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `videobookmarks` ENABLE KEYS */;

--
-- Table structure for table `videosource`
--

DROP TABLE IF EXISTS `videosource`;
CREATE TABLE `videosource` (
  `sourceid` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(128) NOT NULL default '',
  `xmltvgrabber` varchar(128) default NULL,
  `userid` varchar(128) NOT NULL default '',
  `freqtable` varchar(16) NOT NULL default 'default',
  `lineupid` varchar(64) default NULL,
  `password` varchar(64) default NULL,
  `useeit` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`sourceid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `videosource`
--


/*!40000 ALTER TABLE `videosource` DISABLE KEYS */;
LOCK TABLES `videosource` WRITE;
INSERT INTO `videosource` VALUES (1,'dvb','eitonly','','default',NULL,NULL,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `videosource` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

