#ifndef DBHELPER_H_
#define DBHELPER_H_

#include <qstring.h>

/// These are the helper functions for supporting different db backends

class DBHelper {
public:

static QString dbCreateTable(const QString &dbType, const QString &tableName, bool temporary = false);

static QString dbDropTable(const QString &dbType, const QString &tableName);

static QString dbInt(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

static QString dbBigInt(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

static QString dbSmallInt(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

static QString dbTinyInt(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

static QString dbMedInt(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

static QString dbFloat(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "");


static QString dbTimeStamp(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "");

static QString dbDatetime(const QString &dbType, const QString &colName, bool nullable = true, const QString &defaultVal = "");

static QString dbDate(const QString &dbType, const QString &colName, bool nullable = true, const QString &defaultVal = "");

static QString dbYear(const QString &dbType, const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "");

static QString dbBlob(const QString &dbType, const QString &colName, bool nullable = true, const QString &defaultVal = "");

static QString dbText(const QString &dbType, const QString &colName, bool nullable = true);



static QString dbAddIndex(const QString &dbType, const QString &tableName, const QString &indexName, const QString &colList, bool unique = false);

static QString dbDropPKey(const QString &dbType, const QString &tableName);

static QString dbChangeColumn(const QString &dbType, const QString &tableName, const QString &oldColName, const QString &newColDef);

static QString dbReplaceInto(const QString &dbType, const QString &tableName, const QString &fields, const QString &values, unsigned long where);


static QString dbTimetoDOW(const QString &dbType, const QString &colName);

static QString dbTimetoDays(const QString &dbType, const QString &colName);

static QString dbTimetoSeconds(const QString &dbType, const QString &colName);

static QString dbFromUnixTime(const QString &dbType, const QString &colName);

static QString dbHoursMinutes(const QString &dbType, const QString &colName);



static QString dbDateSub(const QString &dbType, const QString &colName1, const QString &colName2);

static QString dbDateAdd(const QString &dbType, const QString &colName1, const QString &colName2);

static QString dbCurrentTimestamp(const QString &dbType);

static QString dbCurrentDate(const QString &dbType);


static QString dbHex(const QString &dbType, const QString &value);

};

#endif 
