/*
 * File:    mythkeysequence.cpp
 *
 * Purpose: See mythkeysequence.h
 */
#include <mythkeysequence.h>
#include <QString>
#include <QStringList>

/*** MythKey ***
 ***************/
MythKey::MythKey( )
{
    this->clear( );
}

MythKey::MythKey( const int key )
{
    if (!(this->setKey( key )))
        this->clear( );
}

MythKey::MythKey( const QString key )
{
    if (!(this->setKey( key )))
        this->clear( );
}

/* MythKey member routines */
void MythKey::clear( )
{
    this->key_assigned = false;
    this->key_str = "";
    this->key_num = 0;
}

bool MythKey::setKey( const int key )
{
    bool retval = false;

    // Passed by key-num are keys, no buttons
    this->is_button = 0;
    QKeySequence keyseq( key );
    if (keyseq.count( ) > 0)
    {
        retval = true;
        this->key_num = keyseq[ 0 ];
        this->key_str = QString(keyseq);
    }
    this->key_assigned = retval;
    return retval;
}

bool MythKey::isRemote( )
{
    return this->is_button;
}

bool MythKey::isAssigned( )
{
    return this->key_assigned;
}

bool MythKey::setKey( const QString key )
{
    this->key_assigned = false;
    bool retval = false;
    if (key.left( 6 ).toLower( ) == "remote")
    {
        retval = true;
        this->is_button = 1;

        /* Use this value as-is, no checking at all */
        this->key_str = key;
        this->key_num = 0;
    }
    else
    {
        this->is_button = 0;

        /* Use the QKeySequence to check this key's validity and to set
         * appropriate fields. We pass ',,' to make the QKeySequence
         * see the ',' because it'll fail on a *single* ','  */
        QString keystr = key.trimmed( );
        QKeySequence keyseq( (keystr == ","?",,":keystr) );
        if (keyseq[ 0 ])
        {
            retval = true;
            this->key_num = keyseq[ 0 ];
            this->key_str = keystr.trimmed( );
        }
//        else printf( "no keyseq\n" );
    }

    this->key_assigned = retval;
    return retval;
}


QString MythKey::text( )
{
    if (this->key_assigned)
    {
        if (this->key_str.length() == 0)
        {
            QString key;
            key.setNum( this->key_num );
            return key;
        }
        else 
	{
            return this->key_str;
	}
    }

    return "";
}

int MythKey::value( )
{
    if (this->key_assigned)
        return this->key_num;
    else
        return 0;
}

MythKey::operator int( )
{
    return this->value( );
}


/*** MythKeySequence ***
 ***********************/
MythKeySequence::MythKeySequence( )
{
    this->clear( );
}

MythKeySequence::MythKeySequence( int k1, int k2, int k3, int k4 )
{
    uint k_index = 0;

    if (k1 > 0) this->keys[ ++k_index ].setKey( k1 );
    if (k2 > 0) this->keys[ ++k_index ].setKey( k2 );
    if (k3 > 0) this->keys[ ++k_index ].setKey( k3 );
    if (k4 > 0) this->keys[ ++k_index ].setKey( k4 );
}

MythKeySequence::MythKeySequence( const QString &keys )
{
    this->setKeys( keys );
}


/* MythKeySequence member routines */
uint MythKeySequence::setKeys( const QString &keys )
{
    QStringList allKeys = keys.split( ",", QString::KeepEmptyParts );
    int max = allKeys.count( );
    int k_index = 0, e_cnt = 0, e_at_start = 0;

    //printf( "Found %d keys in the list [%s].\n", max, keys.data( ) );
    for(int i = 0; i < max; i++)
    {
	//printf( "Processing key [%s].\n", allKeys[i].data( ) );

	if (allKeys[ i ].isEmpty( )) // 2 empties is 1 ','
	{ 
	    e_cnt++;
	    if (e_cnt == 2)
	    {
		this->keys[ k_index ].setKey( QString(",") );
                k_index++;
		e_cnt = 0;
	    }
        }
        else
        {
            //printf( "Adding [%s] as a key...\n", allKeys[i].data( ) );
            this->keys[ k_index ].setKey( allKeys[ i ] );
	    k_index++;
        }

        if (k_index >= MYTHKEY_SEQLEN)
        {
            // positions exhausted -- illegal sequence string...
            break;
        }

    } // for

    /// printf( "%d keys assigned.\n", k_index );
    this->keys_assigned = k_index;
    return k_index;
}

uint MythKeySequence::count( )
{
    return this->keys_assigned;
}

void MythKeySequence::clear( )
{
    this->keys_assigned = 0;

    for(int i=0; i<MYTHKEY_SEQLEN; i++)
        this->keys[ i ].clear( );
}


MythKey* MythKeySequence::operator[]( int index )
{
    if( (index >= 0) && (index < MYTHKEY_SEQLEN) )
        return &(this->keys[ index ]);
    return 0;
}

MythKeySequence::operator QString( )
{
    QString retval = "";
    for (uint i=0; i<MYTHKEY_SEQLEN; i++)
    {
        if (this->keys[i].key_assigned)
        {
            if (retval != "") retval += ", ";
                retval += this->keys[i].text( );
        }
    }
    return retval;
}
