/*
 * File:    mythkeysequence.h
 *
 * Purpose: This implements the MythKeySequence class. QKeySequence cannot
 *          be easily extended not to ignore 'remoteXXX' identifiers.
 *
 *          This replacement class fixes that and removes the need for
 *          some duplicate code in MythTV and the MythControls-plugin.
 *
 * History:
 *
 * 20060620
 *   - Renamed member routine 'keyNum()' to 'value()'.
 *   - Bugfixed problem with 'F1,M,{,<' only assigning 3 keys.
 *   - Max.length of sequence configurable through #define MYTHKEY_SEQLEN.
 */

#ifndef _KEYSEQ_H_
#define _KEYSEQ_H_

#include <QObject>
/* #include <qobject.h> */
#include <QKeySequence>
/* #include <qkeysequence.h> */

/* The #define's below define internal features;
 ***********************************************/

// Maximum length of KeySequence -- default same as QKeySequence:
#ifndef MYTHKEY_SEQLEN

    #define     MYTHKEY_SEQLEN                          4
#else

    #warning    MYTHKEY_SEQLEN is already defined -- skipping assignment.
#endif


/******************** MythKeySequence / MythKey classes **********************/
class MythKeySequence;

class MythKey : public QObject
{
    Q_OBJECT

    public:
        MythKey( );
        MythKey( const int );
        MythKey( const QString );

        /* Assign the key */
        bool    setKey( const int );
        bool    setKey( const QString );
        void    clear( );

        /* Text representation, ie. Ctrl+PgUp, or remoteGUIDE */
        QString text( );
        /* Numeric value, only valid if Keys */
        int     value( );
        /* More query stuff */
        bool    isRemote( );
        bool    isAssigned( );

        operator int();

    private:
        bool    key_assigned;   /* .. */
        int     is_button;      /* Key is a button, i.e. not coming from a keyboard */

        int     key_num;        /* Integer representation of key (is 0 for remote buttons) */
        QString key_str;        /* Text representation of key / button */

    friend class MythKeySequence;
};

class MythKeySequence : public QObject
{
    Q_OBJECT

    public:
        MythKeySequence( );
        MythKeySequence( int k1, int k2=0, int k3=0, int k4=0 );
        MythKeySequence( const QString & );

        /* Assign multiple keys */
        uint        setKeys( const QString & );

        /* Query stuff */
        bool        isEmpty( );
        void        clear( );
        uint        count( );

        MythKey*    operator[]( int index );
        bool        operator ==( const MythKeySequence & );
        operator    QString( );

        MythKey     keys[ MYTHKEY_SEQLEN ];

    private:
        uint        keys_assigned;
};

#endif // _KEYSEQ_H_
