#!/bin/sh

#
# Date: 2005-08-19 10:37
# Version: 3.0
# Author: Jochen Kuehner (jochen.kuehner@gmx.de)
#
# emulator_screenshots.sh
#
# Need's MythGame > 0.18
#
# Description:
#   A SCript to generate Screenshots for your Emulatorgames, wich are used in
#   MythGame in the Game Information. 
#
# Missing Things:
#   - Searching through subdirecorys
#   - Replacing the Extensions in the Commandline
#
# Setup:
#   You need to set the DBUSER and DBPWD Variable in the Script to the right value.
#

DBUSER=root
DBPWD=
DBNAME=mythconverg

PAUSETIME=10 #so long is waited after running the emulator until the screenshot is taken

TMPFILE=/tmp/tmp.png

case "$1" in

 start)

  WERTE=`echo "SELECT playername FROM gameplayers" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`;

  for player in $WERTE
   do 
 
    ROMPATH=`echo "SELECT rompath FROM gameplayers WHERE playername = '$player'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`
    COMMANDLINE=`echo "SELECT commandline FROM gameplayers WHERE playername = '$player'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`
#    EXTENSIONS=`echo "SELECT extensions FROM gameplayers WHERE playername = '$player'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`
    SCREENSHOTS=`echo "SELECT screenshots FROM gameplayers WHERE playername = '$player'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`

    
    cmdpfad=$(dirname "$(echo $COMMANDLINE | cut -d "-" -f 1)")
    cmdprgname=$(basename "$(echo $COMMANDLINE | cut -d "-" -f 1)")
    cmdparameter=${COMMANDLINE:$((`echo "$cmdpfad" | wc -m`+`echo "$cmdprgname" | wc -m`-1)):`echo "$COMMANDLINE" | wc -m`}
    cmdrun=`echo "$cmdpfad/$cmdprgname"`
    
    extens2=${EXTENSIONS//,/ }



    ROMCOUNT=`echo "SELECT COUNT('romname') FROM gamemetadata WHERE system = '$player' AND display = '1'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`

    echo " Generating Screenshots for Player: $player  Rom-Count: $ROMCOUNT";
    
    zaehler=0
    
      while [ "$zaehler" -lt "$ROMCOUNT" ]
      do
        zaehler=$((zaehler + 1))
        ROMNAME=`echo "SELECT romname FROM gamemetadata WHERE system = '$player' AND display = '1' LIMIT $zaehler, 1" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`
        DISKCOUNT=`echo "SELECT diskcount FROM gamemetadata WHERE system = '$player' AND display = '1' AND romname = '$ROMNAME'" | mysql -B --database=$DBNAME --password=$DBPWD --user=$DBUSER -N`
        echo "Screenshot for ROM: $ROMNAME is beeing generated..."
	
	#If Diskcount > 1 then Replace the 3 Rest Disk with the Romname
	if [ "$DISKCOUNT" -gt "1" ]
	  baserom=`basename $ROMNAME`
	  
	  COMMANDLINE=${COMMANDLINE//%d1/"$ROMPATH$ROMNAMEb"}
	  COMMANDLINE=${COMMANDLINE//%d2/"$ROMPATH$ROMNAMEc"}
	  COMMANDLINE=${COMMANDLINE//%d3/"$ROMPATH$ROMNAMEd"}
	fi
	
	#If in the Commandline exists $s or %d0 Replace it with the Romname
	#if not, add the romname at the end of the commandline
	if [ expr "$COMMANDLINE" : '.*%s.*' ]
	  COMMANDLINE=${COMMANDLINE//%s/"$ROMPATH$ROMNAME"}
	  #$COMMANDLINE
	else
	   if [ expr "$COMMANDLINE" : '.*%d0.*' ]
	      COMMANDLINE=${COMMANDLINE//%d0/"$ROMPATH$ROMNAME"}
	      #$COMMANDLINE
	   else
	      $COMMANDLINE="$COMMANDLINE \"$ROMPATH$ROMNAME\""
	      #$COMMANDLINE "$ROMPATH$ROMNAME"
	   fi	
	   
	        myname="$ROMPATH$ROMNAME"
                path="`expr "$myname" : '\(.*\)/'`"                  # get file path (if any)
                name="`expr "//$myname" : '.*/\([^/]*\)'`"           # remove path to file
                suffix="`expr "$name" : '.*\.\([^./]*\)$'`"     # extract last suffix
                name="`expr "$name" : '\(.*\)\.[^.]*$'`"        # remove last suffix
                picname=$name.png
	        picpfd=`echo "$SCREENSHOTS/$picname"`
                if [ -e "$picpfd" ]; then
                   echo "Screenshot exists: $picpfd"
	        else
	           echo "Screenshot $picpfd is being generated"
                   COMMAND="start-stop-daemon --exec $cmdrun --start --background -- $cmdparameter" 
                   $COMMAND "$i"      
                   sleep $PAUSETIME
                   scrot --quality 1 $TMPFILE
                   mv $TMPFILE "$picpfd"
                   killall -9 $cmdrun
                   sleep 1
	        fi 
          fi
	   
	fi
	
      done

    done
  ;;
  
  *)
  echo ""
  echo "This is a Script to generate Screenshots for your Emulators, wich"
  echo "you have set up in MythTV automaticaly. It uses the program scrot"
  echo "to generate the screenshot."
  echo ""
  echo "To run you had to enter: emulator_screenshots start"
  echo "Bevor running, check the username and passwort in the script"
  echo "Also the timeout until the screenshot is taken can be adjusted"
  ;;
esac
