#ifndef LIBVISUALPLUGIN_H
#define LIBVISUALPLUGIN_H

#include "mainvisual.h"
#include "config.h"

#if defined(SDL_SUPPORT) && defined(LIBVISUAL_SUPPORT) 
extern "C"
{
    #include <libvisual/libvisual.h>
    #include <SDL.h>
}

class LibVisualPlugin : public VisualBase
{
  public:
    LibVisualPlugin(long int winid);
    virtual ~LibVisualPlugin();

    void resize(const QSize &size);
    bool process(VisualNode *node = 0);
    bool draw(QPainter *p, const QColor &back = Qt::black);

  private:
    static int AudioCallback(VisInput *input, VisAudio *audio, void *priv);

  private:
    VisBin*      m_pVisBin;            // Pointer to LibVisualPlugin representation of an application
    VisVideo*    m_pVisVideo;          // Pointer to LibVisualPlugin representation of a screen surface

    SDL_Surface* m_pSurface;           // Pointer to SDL representation of rendering surface

    int16_t      m_Audio[2][512];      // PCM audio data transfer buffer
};


class LibVisualPluginFactory : public VisFactory
{
  public:
    const QString &name(void) const;
    const QString &description(void) const;
    VisualBase *create(MainVisual *parent, long int winid);
};

#endif // SDL_SUPPORT && LIBVISUAL_SUPPORT

#endif // LIBVISUALPLUGIN_H
