#include "mysqlhelper.h"

#include "mythcontext.h"
#include "mythdbcon.h"

QString MySQLHelper::dbCreateTable(const QString &tableName, bool temporary)
{
    QString retval = "CREATE ";

    if (temporary)
       retval += "TEMPORARY ";
    retval += "TABLE IF NOT EXISTS " + tableName;

    return retval;
}

QString MySQLHelper::dbTableTypeMyISAM()
{
    return "TYPE=MyISAM";
}

QString MySQLHelper::dbDropTable(const QString &tableName)
{
    return QString("DROP TABLE IF EXISTS " + tableName);
}

QString MySQLHelper::dbGroupByWithoutAggregate(const QString &fieldList)
{
    return " GROUP BY " + fieldList + " " ;
}

QString MySQLHelper::dbInt(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal, bool auto_num)
{
   QString retval = colName;

    retval += " int";
    if (width.length() > 0)
        retval += "(" + width + ")";
    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    if (auto_num)
        retval += " auto_increment";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;


   return retval;
}


QString MySQLHelper::dbTinyInt(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal, bool auto_num)
{
    QString retval = colName;

    retval += " tinyint";
    if (width.length() > 0)
        retval += "(" + width + ")";
    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    if (auto_num)
        retval += " auto_increment";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

   return retval;
}


QString MySQLHelper::dbBigInt(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal, bool auto_num)
{
    QString retval = colName;

    retval += " bigint";
    if (width.length() > 0)
        retval += "(" + width + ")";
    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    if (auto_num)
        retval += " auto_increment";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

   return retval;
}


QString MySQLHelper::dbSmallInt(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal, bool auto_num)
{
    QString retval = colName;


    retval += " smallint";
    if (width.length() > 0)
        retval += "(" + width + ")";
    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    if (auto_num)
        retval += " auto_increment";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

   return retval;
}


QString MySQLHelper::dbMedInt(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal, bool auto_num)
{
    QString retval = colName;

    retval += " mediumint";
    if (width.length() > 0)
        retval += "(" + width + ")";
    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    if (auto_num)
        retval += " auto_increment";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

    return retval;
}

QString MySQLHelper::dbFloat(const QString &colName, const QString &width, bool nullable, bool unsignedCol, const QString &defaultVal)
{
    QString retval = colName + " float";

    if (width.length() > 0)
        retval += "(" + width + ")";

    if (unsignedCol)
        retval += " unsigned";
    if (!nullable)
        retval += " NOT NULL";
    else if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

   return retval;
}

QString MySQLHelper::dbTimeStamp(const QString &colName, const QString &width, bool nullable, const QString &defaultVal)
{
    QString retval = colName + " TIMESTAMP";

    if (width.length() > 0)
        retval += "(" + width + ")";

    if (!nullable)
       retval += " NOT NULL";

    if (defaultVal.length() > 0) {
        retval += " default " + defaultVal;
    }

    return retval;
}


QString MySQLHelper::dbDatetime(const QString &colName, bool nullable, const QString &defaultVal)
{
    QString retval = colName + " DATETIME";

    if (!nullable)
        retval += " NOT NULL";

    if (defaultVal.length() > 0) {
        retval += " default " + defaultVal;
    }

   return retval;
}


QString MySQLHelper::dbDate(const QString &colName, bool nullable, const QString &defaultVal)
{
    QString retval = colName + " DATE";

    if (!nullable)
        retval += " NOT NULL";

    if (defaultVal.length() > 0)
        retval += " default " + defaultVal;

    return retval;
}


QString MySQLHelper::dbYear(const QString &colName, const QString &width, bool nullable, const QString &defaultVal)
{
    QString retval = colName + " YEAR";

    if (width.length() > 0)
        retval += "(" + width + ")";

    if (!nullable)
        retval += " NOT NULL";

    if (defaultVal.length() > 0)
        retval += " DEFAULT " + defaultVal;

    return retval;
}

QString MySQLHelper::dbGetYear(const QString &colName)
{
    return colName;
}

QString MySQLHelper::dbBlob(const QString &colName, bool nullable, const QString &defaultVal)
{
    QString retval = colName + " BLOB";

    if (!nullable)
       retval += " NOT NULL";

    if (defaultVal.length() > 0)
        retval += " DEFAULT " + defaultVal;

    return retval;
}

QString MySQLHelper::dbText(const QString &colName, bool nullable)
{
    QString retval = colName + " TEXT";

    if (!nullable)
       retval += " NOT NULL";

    return retval;
}

QString MySQLHelper::dbAddIndex(const QString &tableName, const QString &indexName, const QString &colList, bool unique)
{
    QString retval = "CREATE ";
    QString s;

    if (unique)
        retval += "UNIQUE ";

    retval += "INDEX " + tableName + "_" + indexName + "_idx ON " 
           + tableName + " (" + colList + ")";

    return retval;
}

QString MySQLHelper::dbDropPKey(const QString &tableName)
{
    return "ALTER TABLE " + tableName + " DROP PRIMARY KEY";
}

QString MySQLHelper::dbAnalyzeTable(const QString &tableName)
{
    return "ANALYZE TABLE " + tableName + ";";
}

QString MySQLHelper::dbChangeColumn(const QString &tableName, const QString &oldColName, const QString &newColDef)
{
    return "ALTER TABLE " + tableName + " CHANGE " + oldColName 
          + " " + newColDef;
}

QString MySQLHelper::dbTimetoDOW(const QString &colName)
{
    return " DAYOFWEEK(" + colName + ") ";
}

QString MySQLHelper::dbTimetoDays(const QString &colName)
{
    return " TO_DAYS( " + colName + ") ";
}

QString MySQLHelper::dbTimetoSeconds(const QString &colName)
{
    return " TIME_TO_SEC( " + colName + ") ";
}

QString MySQLHelper::dbFromUnixTime(const QString &colName)
{
    return " interval " + colName + " second ";
}

QString MySQLHelper::dbHoursMinutes(const QString &colName)
{
    return " interval time_format(" + colName + ", '%H:%i') hour_minute ";
}

QString MySQLHelper::dbYearThroughMinute(const QString &colName)
{
    return " DATE_FORMAT(" + colName + ", '%Y%m%dT%H%i00') ";
}

QString MySQLHelper::dbDateSub(const QString &colName1, const QString &colName2)
{
    return " DATE_SUB(" + colName1 + ", " + colName2 + ") ";
}


QString MySQLHelper::dbDateAdd(const QString &colName1, const QString &colName2)
{
    return " DATE_ADD(" + colName1 + ", " + colName2 + ") ";
}

QString MySQLHelper::dbCurrentTimestamp()
{
    return " CURRENT_TIMESTAMP() ";
}

QString MySQLHelper::dbCurrentDate()
{
    return " CURRENT_DATE() ";
}

QString MySQLHelper::dbStrConcat(const QString &strList)
{
    return " CONCAT (" + strList + ") ";
}

QString MySQLHelper::dbCharToInt(const QString &colName)
{
    return colName + " + 0";
}

QString MySQLHelper::dbHex(const QString &value)
{
    return " 0x" + value;
}

QString MySQLHelper::dbNextInsertID
    (const QString &tableName, const QString &colName)
{
    MSqlQuery query(MSqlQuery::InitCon());

    QString querystr = QString("INSERT INTO %1 (%2) VALUES (0);")
                               .arg(tableName).arg(colName);

    query.exec(querystr);

    if (!query.isActive() || query.numRowsAffected() < 1) 
    {
        MythContext::DBError("inserting row", query);
        return "-1";
    }

    query.exec("SELECT LAST_INSERT_ID();");

    if (!query.isActive() || query.size() < 1) 
    {
        MythContext::DBError("selecting last insert id", query);
        return "-1";
    }

    query.next();

    return query.value(0).toString();
}

QString MySQLHelper::dbLockTable(const QString &tableName)
{
    return "LOCK TABLE " + tableName + " WRITE;";
}

QString MySQLHelper::dbUnlockTables()
{
    return "UNLOCK TABLES;";
}
