#ifndef DBHELPERBASE_H_
#define DBHELPERBASE_H_

#include <qstring.h>

/// These are the helper functions for supporting different db backends

class DBHelperBase {
public:

virtual QString dbCreateTable(const QString &tableName, bool temporary = false) = 0;

virtual QString dbTableTypeMyISAM() = 0;

virtual QString dbDropTable(const QString &tableName) = 0;

virtual QString dbGroupByWithoutAggregate(const QString &fieldList) = 0;

virtual QString dbInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false) = 0;

virtual QString dbBigInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false) = 0;

virtual QString dbSmallInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false) = 0;

virtual QString dbTinyInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false) = 0;

virtual QString dbMedInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false) = 0;

virtual QString dbFloat(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "") = 0;


virtual QString dbTimeStamp(const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "") = 0;

virtual QString dbDatetime(const QString &colName, bool nullable = true, const QString &defaultVal = "") = 0;

virtual QString dbDate(const QString &colName, bool nullable = true, const QString &defaultVal = "") = 0;

virtual QString dbYear(const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "") = 0;

virtual QString dbGetYear(const QString &colName) = 0;

virtual QString dbBlob(const QString &colName, bool nullable = true, const QString &defaultVal = "") = 0;

virtual QString dbText(const QString &colName, bool nullable = true) = 0;



virtual QString dbAddIndex(const QString &tableName, const QString &indexName, const QString &colList, bool unique = false) = 0;

virtual QString dbDropPKey(const QString &tableName) = 0;

virtual QString dbAnalyzeTable(const QString &tableName) = 0;

virtual QString dbChangeColumn(const QString &tableName, const QString &oldColName, const QString &newColDef) = 0;

virtual QString dbReplaceInto(const QString &tableName, const QString &fields, const QString &values, unsigned long where) = 0;


virtual QString dbTimetoDOW(const QString &colName) = 0;

virtual QString dbTimetoDays(const QString &colName) = 0;

virtual QString dbTimetoSeconds(const QString &colName) = 0;

virtual QString dbFromUnixTime(const QString &colName) = 0;

virtual QString dbHoursMinutes(const QString &colName) = 0;



virtual QString dbDateSub(const QString &colName1, const QString &colName2) = 0;

virtual QString dbDateAdd(const QString &colName1, const QString &colName2) = 0;

virtual QString dbCurrentTimestamp() = 0;

virtual QString dbCurrentDate() = 0;


virtual QString dbCharToInt(const QString &colName) = 0;

virtual QString dbHex(const QString &value) = 0;

virtual QString dbNextInsertID
    (const QString &tableName, const QString &colName) = 0;

virtual QString dbLockTable(const QString &tableName) = 0;

virtual QString dbUnlockTables() = 0;

virtual ~DBHelperBase() {}

protected:

DBHelperBase() {}

};

#endif 
