#include "dbhelper.h"
#include "mythcontext.h"

#include "pgsqlhelper.h"
#include "mysqlhelper.h"

DBHelperBase* DBHelper::instance_ = 0;

DBHelperBase* DBHelper::getInstance() 
{
    QString dbType = gContext->GetDatabaseParams().dbType;

    if (0 == instance_)
    {
        if (dbType == DBTYPE_MYSQL)
            instance_ = new MySQLHelper();
        else if (dbType == DBTYPE_PGSQL)
            instance_ = new PGSQLHelper();
    }

    return instance_;
}


void DBHelper::deleteInstance() 
{
    if (0 != instance_)
        delete instance_;
}