#ifndef MYSQLHELPER_H_
#define MYSQLHELPER_H_

#include <qstring.h>

#include "dbhelperbase.h"

/// These are the helper functions for supporting different db backends

class MySQLHelper : public DBHelperBase {

friend class DBHelper;

public:

virtual QString dbCreateTable(const QString &tableName, bool temporary = false);

virtual QString dbTableTypeMyISAM();

virtual QString dbDropTable(const QString &tableName);

virtual QString dbGroupByWithoutAggregate(const QString &fieldList);

virtual QString dbInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

virtual QString dbBigInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

virtual QString dbSmallInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

virtual QString dbTinyInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

virtual QString dbMedInt(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "", bool auto_num = false);

virtual QString dbFloat(const QString &colName, const QString &width = "", bool nullable = true, bool unsignedCol = false, const QString &defaultVal = "");


virtual QString dbTimeStamp(const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "");

virtual QString dbDatetime(const QString &colName, bool nullable = true, const QString &defaultVal = "");

virtual QString dbDate(const QString &colName, bool nullable = true, const QString &defaultVal = "");

virtual QString dbYear(const QString &colName, const QString &width = "", bool nullable = true, const QString &defaultVal = "");

virtual QString dbGetYear(const QString &colName);

virtual QString dbBlob(const QString &colName, bool nullable = true, const QString &defaultVal = "");

virtual QString dbText(const QString &colName, bool nullable = true);



virtual QString dbAddIndex(const QString &tableName, const QString &indexName, const QString &colList, bool unique = false);

virtual QString dbDropPKey(const QString &tableName);

virtual QString dbAnalyzeTable(const QString &tableName);

virtual QString dbChangeColumn(const QString &tableName, const QString &oldColName, const QString &newColDef);

virtual QString dbReplaceInto(const QString &tableName, const QString &fields, const QString &values, unsigned long where);


virtual QString dbTimetoDOW(const QString &colName);

virtual QString dbTimetoDays(const QString &colName);

virtual QString dbTimetoSeconds(const QString &colName);

virtual QString dbFromUnixTime(const QString &colName);

virtual QString dbHoursMinutes(const QString &colName);



virtual QString dbDateSub(const QString &colName1, const QString &colName2);

virtual QString dbDateAdd(const QString &colName1, const QString &colName2);

virtual QString dbCurrentTimestamp();

virtual QString dbCurrentDate();


virtual QString dbCharToInt(const QString &colName);

virtual QString dbHex(const QString &value);

virtual QString dbNextInsertID
    (const QString &tableName, const QString &colName);

virtual QString dbLockTable(const QString &tableName);

virtual QString dbUnlockTables();

private:

MySQLHelper() {}

};

#endif 
