#include "dbhelperbase.h"

const QString DBHelperBase::CreateTable(const QString &tableName, bool temporary) const
{
    return dbCreateTable(tableName, temporary);
}

const QString DBHelperBase::TableTypeMyISAM() const
{
    return dbTableTypeMyISAM();
}

const QString DBHelperBase::DropTable(const QString &tableName) const
{
    return dbDropTable(tableName);
}

const QString DBHelperBase::GroupByWithoutAggregate(const QString &fieldList) const
{
    return dbGroupByWithoutAggregate(fieldList);
}

const QString DBHelperBase::Int(const QString &colName, const QString &width, int size, int flags, const QString &defaultVal) const
{
    return dbInt(colName, width, size, flags, defaultVal);
}

const QString DBHelperBase::Float(const QString &colName, const QString &width, int flags, const QString &defaultVal) const
{
    return dbFloat(colName, width, flags, defaultVal);
}


const QString DBHelperBase::TimeStamp(const QString &colName, const QString &width, int flags, const QString &defaultVal) const
{
    return dbTimeStamp(colName, width, flags, defaultVal);
}

const QString DBHelperBase::Datetime(const QString &colName, int flags, const QString &defaultVal) const
{
    return dbDatetime(colName, flags, defaultVal);
}

const QString DBHelperBase::Date(const QString &colName, int flags, const QString &defaultVal) const
{
    return dbDate(colName, flags, defaultVal);
}

const QString DBHelperBase::Year(const QString &colName, const QString &width, int flags, const QString &defaultVal) const
{
    return dbYear(colName, width, flags, defaultVal);
}

const QString DBHelperBase::GetYear(const QString &colName) const
{
    return dbGetYear(colName);
}

const QString DBHelperBase::Blob(const QString &colName, int flags, const QString &defaultVal) const
{
    return dbBlob(colName, flags, defaultVal);
}

const QString DBHelperBase::Text(const QString &colName, int flags) const
{
    return dbText(colName, flags);
}



const QString DBHelperBase::AddIndex(const QString &tableName, const QString &indexName, const QString &colList, bool unique) const
{
    return dbAddIndex(tableName, indexName, colList, unique);
}

const QString DBHelperBase::DropPKey(const QString &tableName) const
{
    return dbDropPKey(tableName);
}

const QString DBHelperBase::AnalyzeTable(const QString &tableName) const
{
    return dbAnalyzeTable(tableName);
}

const QString DBHelperBase::ChangeColumn(const QString &tableName, const QString &oldColName, const QString &newColDef) const
{
    return dbChangeColumn(tableName, oldColName, newColDef);
}


const QString DBHelperBase::TimetoDOW(const QString &colName) const
{
    return dbTimetoDOW(colName);
}

const QString DBHelperBase::TimetoDays(const QString &colName) const
{
    return dbTimetoDays(colName);
}

const QString DBHelperBase::TimetoSeconds(const QString &colName) const
{
    return dbTimetoSeconds(colName);
}

const QString DBHelperBase::FromUnixTime(const QString &colName) const
{
    return dbFromUnixTime(colName);
}

const QString DBHelperBase::HoursMinutes(const QString &colName) const
{
    return dbHoursMinutes(colName);
}

const QString DBHelperBase::YearThroughMinute(const QString &colName) const
{
    return dbYearThroughMinute(colName);
}



const QString DBHelperBase::DateSub(const QString &colName1, const QString &colName2) const
{
    return dbDateSub(colName1, colName2);
}

const QString DBHelperBase::DateAdd(const QString &colName1, const QString &colName2) const
{
    return dbDateAdd(colName1, colName2);
}

const QString DBHelperBase::CurrentTimestamp() const
{
    return dbCurrentTimestamp();
}

const QString DBHelperBase::CurrentDate() const
{
    return dbCurrentDate();
}


const QString DBHelperBase::StrConcat(const QString &strList) const
{
    return dbStrConcat(strList);
}

const QString DBHelperBase::MatchRegEx(const QString &str, const QString &regex) const
{
    return dbMatchRegEx(str, regex);
}

const QString DBHelperBase::NotMatchRegEx(const QString &str, const QString &regex) const
{
    return dbNotMatchRegEx(str, regex);
}

const QString DBHelperBase::Hex(const QString &value) const
{
    return dbHex(value);
}

const QString DBHelperBase::NextInsertID
    (const QString &tableName, const QString &colName) const
{
    return dbNextInsertID(tableName, colName);
}

const QString DBHelperBase::LockTable(const QString &tableName) const
{
    return dbLockTable(tableName);
}

const QString DBHelperBase::UnlockTables() const
{
    return dbUnlockTables();
}

const QString DBHelperBase::NameEscape() const
{
    return dbNameEscape();
}
