#ifndef MYSQLHELPER_H_
#define MYSQLHELPER_H_

#include <qstring.h>

#include "dbhelperbase.h"

/// These are the helper functions for supporting different db backends

class MySQLHelper : public DBHelperBase {

friend class DBHelper;

public:

virtual const QString dbCreateTable(const QString &tableName, bool temporary) const;

virtual const QString dbTableTypeMyISAM() const;

virtual const QString dbDropTable(const QString &tableName) const;

virtual const QString dbGroupByWithoutAggregate(const QString &fieldList) const;

virtual const QString dbInt(const QString &colName, const QString &width, int size, int flags, const QString &defaultVal) const;

virtual const QString dbFloat(const QString &colName, const QString &width, int flags, const QString &defaultVal) const;


virtual const QString dbTimeStamp(const QString &colName, const QString &width, int flags, const QString &defaultVal) const;

virtual const QString dbDatetime(const QString &colName, int flags, const QString &defaultVal) const;

virtual const QString dbDate(const QString &colName, int flags, const QString &defaultVal) const;

virtual const QString dbYear(const QString &colName, const QString &width, int flags, const QString &defaultVal) const;

virtual const QString dbGetYear(const QString &colName) const;

virtual const QString dbBlob(const QString &colName, int flags, const QString &defaultVal) const;

virtual const QString dbText(const QString &colName, int flags) const;



virtual const QString dbAddIndex(const QString &tableName, const QString &indexName, const QString &colList, bool unique) const;

virtual const QString dbDropPKey(const QString &tableName) const;

virtual const QString dbAnalyzeTable(const QString &tableName) const;

virtual const QString dbChangeColumn(const QString &tableName, const QString &oldColName, const QString &newColDef) const;


virtual const QString dbTimetoDOW(const QString &colName) const;

virtual const QString dbTimetoDays(const QString &colName) const;

virtual const QString dbTimetoSeconds(const QString &colName) const;

virtual const QString dbFromUnixTime(const QString &colName) const;

virtual const QString dbHoursMinutes(const QString &colName) const;

virtual const QString dbYearThroughMinute(const QString &colName) const;



virtual const QString dbDateSub(const QString &colName1, const QString &colName2) const;

virtual const QString dbDateAdd(const QString &colName1, const QString &colName2) const;

virtual const QString dbCurrentTimestamp() const;

virtual const QString dbCurrentDate() const;


virtual const QString dbStrConcat(const QString &strList) const;

virtual const QString dbMatchRegEx(const QString &str, const QString &regex) const;

virtual const QString dbNotMatchRegEx(const QString &str, const QString &regex) const;

virtual const QString dbHex(const QString &value) const;

virtual const QString dbNextInsertID
    (const QString &tableName, const QString &colName) const;

virtual const QString dbLockTable(const QString &tableName) const;

virtual const QString dbUnlockTables() const;

virtual const QString dbNameEscape() const;

protected:

MySQLHelper() {}

};

#endif 
