#include "dbhelper.h"
#include "mythcontext.h"

#include "pgsqlhelper.h"
#include "mysqlhelper.h"

DBHelperBase* DBHelper::m_instance = 0;
QMutex        DBHelper::m_mutex;

DBHelperBase& DBHelper::getInstance() 
{
    DBHelperBase* temp = m_instance;

    QString dbType = gContext->GetDatabaseParams().dbType;

    if (0 == temp)
    {
        //put lock here
        QMutexLocker lock(&m_mutex);
        temp = m_instance;
        if (0 == temp)
        {
           if (dbType == DBTYPE_MYSQL)
               temp = new MySQLHelper();
           else if (dbType == DBTYPE_PGSQL)
               temp = new PGSQLHelper();

           m_instance = temp;
        }
    }

    return *m_instance;
}


void DBHelper::deleteInstance() 
{
    QMutexLocker lock(&m_mutex);
    delete m_instance;
}
