/*
	main.cpp

	Starting point for the myth lcd server daemon

*/

#include <qapplication.h>
#include <qsqldatabase.h>
#include <qfile.h>
#include <qtextstream.h>

#include <iostream>
using namespace std;
#include <unistd.h>

#include <mythtv/exitcodes.h>
#include <mythtv/mythcontext.h>
#include <mythtv/mythdbcon.h>

#include "lcdserver.h"

#define LCD_EXIT_DEAMONIZING_ERROR                FRONTEND_EXIT_START-1
#define LCD_EXIT_NO_TRANSCODE_SUPPORT             FRONTEND_EXIT_START-2

int main(int argc, char **argv)
{
    QApplication a(argc, argv, false);
    bool daemon_mode = false;
    int  special_port = -1;    
    QString startup_message = "";  // default to no startup message
    int message_time = 30;         // time to display startup message  
    
    //  Check command line arguments
    for (int argpos = 1; argpos < a.argc(); ++argpos)
    {
        
        if (!strcmp(a.argv()[argpos],"-d") ||
            !strcmp(a.argv()[argpos],"--daemon"))
        {
            daemon_mode = true;
        }
        else if (!strcmp(a.argv()[argpos],"-n") ||
            !strcmp(a.argv()[argpos],"--nodaemon"))
        {
            daemon_mode = false;
        }
        else if (!strcmp(a.argv()[argpos],"-p") ||
            !strcmp(a.argv()[argpos],"--port"))
        {
            if (a.argc() > argpos)
            {
                QString port_number = a.argv()[argpos+1];
                ++argpos;
                special_port = port_number.toInt();
                if (special_port < 1 || special_port > 65534)
                {
                    VERBOSE(VB_ALL, "lcdserver: Bad port number");
                    return FRONTEND_EXIT_INVALID_CMDLINE;
                }
            } 
            else 
            {
                VERBOSE(VB_ALL, "lcdserver: Missing argument to "
                                "-p/--port option");
                return FRONTEND_EXIT_INVALID_CMDLINE;
            }
        }
        else if (!strcmp(a.argv()[argpos],"-m") ||
            !strcmp(a.argv()[argpos],"--startupmessage"))
        {
            if (a.argc() > argpos)
            {
                startup_message = a.argv()[argpos+1];
                ++argpos;
            } 
            else 
            {
                VERBOSE(VB_ALL, "lcdserver: Missing argument to "
                                "-m/--startupmessage");
                return FRONTEND_EXIT_INVALID_CMDLINE;
            }
        }
        else if (!strcmp(a.argv()[argpos],"-t") ||
            !strcmp(a.argv()[argpos],"--messagetime"))
        {
            if (a.argc() > argpos)
            {
                QString sTime = a.argv()[argpos+1];
                ++argpos;
                message_time = sTime.toInt();
                if (message_time < 1 || message_time > 1000)
                {
                    VERBOSE(VB_ALL, "lcdserver: Bad show message time");
                    return FRONTEND_EXIT_INVALID_CMDLINE;
                }
            } 
            else 
            {
                VERBOSE(VB_ALL, "lcdserver: Missing argument to "
                                "-t/--messagetime");
                return FRONTEND_EXIT_INVALID_CMDLINE;
            }
        }
        else
        {
            cerr << "Invalid argument: " << a.argv()[argpos] << endl <<
                    "Valid options are: " << endl <<
                    "-p or --port number    A port number to listen on (default is 6545) " << endl <<
                    "-d or --daemon         Runs lcd server as a daemon " << endl <<
                    "-n or --nodaemon       Does not run lcd server as a daemon (default)" << endl <<
                    "-m or --startupmessage Message to show at startup" << endl <<
                    "-t or --messagetime    How long to show startup message (default is 30 seconds)" << endl;  
            return FRONTEND_EXIT_INVALID_CMDLINE;
        }
    }
    
    //  Switch to daemon mode?
    if (daemon_mode)
    {
        if (daemon(0, 1) < 0)
        {
            VERBOSE(VB_ALL, "lcdserver: Failed to run as a daemon. "
                            "Bailing out.");
            return LCD_EXIT_DEAMONIZING_ERROR;
        }
        cout << endl;
    }

    //  Get the Myth context and db hooks
    gContext = NULL;
    gContext = new MythContext(MYTH_BINARY_VERSION);
    if (!gContext->Init(false))
    {
        VERBOSE(VB_ALL, "lcdserver: Could not initialize myth context. "
                        "Exiting.");
        return FRONTEND_EXIT_NO_MYTHCONTEXT;
    }

    gContext->ConnectToMasterServer();

    //  Figure out port to listen on
    int assigned_port = gContext->GetNumSetting("LCDServerPort", 6545);
    if (special_port > 0)
    {
        assigned_port = special_port;
    }
   
    new LCDServer(assigned_port, startup_message, message_time);
    
    a.exec();
                                
    delete gContext;
    return FRONTEND_EXIT_OK;
}

