
#include "osd.h"
#include "osdsurface.h"
#include "osdtypes.h"
#include "osdtypeteletext.h"
#include "ttfont.h"

#include <qcolor.h>
#include <qapplication.h>
#include <iostream>
#include <cmath>

using namespace std;

QColor m_color_black;
QColor m_color_red;
QColor m_color_green;
QColor m_color_yellow;
QColor m_color_blue;
QColor m_color_magneta;
QColor m_color_cyan;
QColor m_color_white;

/*****************************************************************************/
OSDTypeTeletext::OSDTypeTeletext(const QString &name, QRect displayrect,
                                 TTFFont *font)
               : OSDType(name)
{
    // XXX -- Alloc tmp surface?
    m_surface = NULL;

    m_displayrect = displayrect;
    m_font = font;

    m_tt_colspace = m_displayrect.width() / m_tt_cols;
    m_tt_rowspace = m_displayrect.height() / m_tt_rows;

    // Why the hell is this needed?????
    qApp->lock();
    m_color_black = QColor("black");
    m_color_red = QColor("red");
    m_color_green = QColor("green");
    m_color_yellow = QColor("yellow");
    m_color_blue = QColor("blue");
    m_color_magneta = QColor("magneta");
    m_color_cyan = QColor("cyan");
    m_color_white = QColor("white");
    qApp->unlock();

}

OSDTypeTeletext::OSDTypeTeletext(const OSDTypeTeletext &other)
               : QObject(), TeletextView(), OSDType(other.m_name)
{
}

OSDTypeTeletext::~OSDTypeTeletext()
{
}

void OSDTypeTeletext::pageUpdated(int page)
{
    if (page != m_curpage)
        return;

    m_pageupdated = true;
    Changed();
}

void OSDTypeTeletext::headerUpdated(uint8_t* page, int lang)
{
    m_curheader = page;
    m_pageupdated = false;
    // XXX
    //drawHeader(page, lang); 
    //Changed();
}

void OSDTypeTeletext::setForegroundColor(int color)
{
    switch(color & ~TTCOLOR_TRANSPARENT)
    {
        case TTCOLOR_BLACK:     m_font->setColor(m_color_black); break;
        case TTCOLOR_RED:       m_font->setColor(m_color_red); break;
        case TTCOLOR_GREEN:     m_font->setColor(m_color_green); break;
        case TTCOLOR_YELLOW:    m_font->setColor(m_color_yellow); break;
        case TTCOLOR_BLUE:      m_font->setColor(m_color_blue); break;
        case TTCOLOR_MAGNETA:   m_font->setColor(m_color_magneta); break;
        case TTCOLOR_CYAN:      m_font->setColor(m_color_cyan); break;
        case TTCOLOR_WHITE:     m_font->setColor(m_color_white); break;
    }

    m_font->setShadow(0,0);
    m_font->setOutline(0);
}

void OSDTypeTeletext::setBackgroundColor(int ttcolor)
{
    QColor color;

    switch(ttcolor & ~TTCOLOR_TRANSPARENT)
    {
        case TTCOLOR_BLACK:     color = m_color_black; break;
        case TTCOLOR_RED:       color = m_color_red; break;
        case TTCOLOR_GREEN:     color = m_color_green; break;
        case TTCOLOR_YELLOW:    color = m_color_yellow; break;
        case TTCOLOR_BLUE:      color = m_color_blue; break;
        case TTCOLOR_MAGNETA:   color = m_color_magneta; break;
        case TTCOLOR_CYAN:      color = m_color_cyan; break;
        case TTCOLOR_WHITE:     color = m_color_white; break;
    }


    int r = color.red();
    int g = color.green();
    int b = color.blue();

    float y = (0.299*r) + (0.587*g) + (0.114*b);
    float u = (0.564*(b - y)); // = -0.169R-0.331G+0.500B
    float v = (0.713*(r - y)); // = 0.500R-0.419G-0.081B

    m_bgcolor_y = (uint8_t)(y);
    m_bgcolor_u = (uint8_t)(127 + u);
    m_bgcolor_v = (uint8_t)(127 + v);
    m_bgcolor_a = 0xff;
}

void OSDTypeTeletext::drawBackground(int x, int y, bool transparent)
{
    (void)transparent;
    (void)x;
    (void)y;

    x *= m_tt_colspace;
    x += m_displayrect.left();

    y *= m_tt_rowspace;
    y += m_displayrect.top();

    drawRect(x, y, m_tt_colspace, m_tt_rowspace);
}

void OSDTypeTeletext::drawRect(int x, int y, int dx, int dy)
{
    // XXX TODO: Move to blend.c or osdsurface.cpp
    
    QRect all(x, y, dx, dy);
    m_surface->AddRect(all);
    
    int luma_stride = m_surface->width;
    int chroma_stride = m_surface->width >> 1;
    int ye = y + dy;
    
    unsigned char *buf_y = m_surface->y + (luma_stride * y) + x;
    unsigned char *buf_u = m_surface->u + (chroma_stride * (y>>1)) + (x>>1);
    unsigned char *buf_v = m_surface->v + (chroma_stride * (y>>1)) + (x>>1);
    unsigned char *buf_a = m_surface->alpha + (luma_stride * y) + x;

    for (; y<ye; ++y)
    {
        for (int i=0; i<dx; ++i)
        {
            buf_y[i] = m_bgcolor_y;
            buf_a[i] = m_bgcolor_a;
        }

        if ((y & 1) == 0)
        {
            for (int i=0; i<dx; ++i)
            {
                buf_u[i>>1] = m_bgcolor_u;
                buf_v[i>>1] = m_bgcolor_v;
            }

            buf_u += chroma_stride;
            buf_v += chroma_stride;
        }

        buf_y += luma_stride;
        buf_a += luma_stride;
    }
}

void OSDTypeTeletext::drawCharacter(int x, int y, QChar ch, int doubleheight)
{
    if (!m_font)
        return;

    QString line = ch;

    x *= m_tt_colspace;
    x += m_displayrect.left();

    y *= m_tt_rowspace;
    y += m_displayrect.top();

    m_font->DrawString(m_surface, x, y, line,
                       m_surface->width, m_surface->height, 255, doubleheight!=0);
}

void OSDTypeTeletext::drawMosaic(int x, int y, int code, int doubleheight)
{
    (void)x;
    (void)y;
    (void)code;

    x *= m_tt_colspace;
    x += m_displayrect.left();

    y *= m_tt_rowspace;
    y += m_displayrect.top();
    
    int dx = (int)round(m_tt_colspace / 2)+1;
    int dy = (int)round(m_tt_rowspace / 3)+1;
   
    if (doubleheight != 0)
    {
	dx *= 2;
	dy *= 2;
    }

    if (code & 0x10) drawRect(x, y + 2*dy, dx, dy);
    if (code & 0x40) drawRect(x + dx, y + 2*dy, dx, dy);
    if (code & 0x01) drawRect(x, y, dx, dy);
    if (code & 0x02) drawRect(x + dx, y, dx, dy);
    if (code & 0x04) drawRect(x, y + dy, dx, dy);
    if (code & 0x08) drawRect(x + dx, y + dy, dx, dy);
}

void OSDTypeTeletext::Reinit(float wchange, float hchange)
{
    m_displayrect = QRect((int)(m_displayrect.x() * wchange),
                          (int)(m_displayrect.y() * hchange),
                          (int)(m_displayrect.width() * wchange),
                          (int)(m_displayrect.height() * hchange));

    m_tt_colspace = m_displayrect.width() / m_tt_cols;
    m_tt_rowspace = m_displayrect.height() / m_tt_rows;
}

void OSDTypeTeletext::Draw(OSDSurface *surface, int fade, int maxfade,
                           int xoff, int yoff)
{
    (void)surface;
    (void)fade;
    (void)maxfade;
    (void)xoff;
    (void)yoff;

    m_surface = surface;
    drawPage();
}
