#ifndef OSD_TYPE_TELETEXT_H_
#define OSD_TYPE_TELETEXT_H_

#include <vector>
using namespace std;

#include <qstring.h>
#include <qrect.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <qobject.h>
#include <qcolor.h>
#include <qmutex.h>

#include "osdtypes.h"
#include "teletextdecoder.h"

class TTFFont;
class OSDType;
class OSDSurface;
class TV;

class TTColor
{
  public:
    static const uint BLACK       = 0;
    static const uint RED         = 1;
    static const uint GREEN       = 2;
    static const uint YELLOW      = 3;
    static const uint BLUE        = 4;
    static const uint MAGENTA     = 5;
    static const uint CYAN        = 6;
    static const uint WHITE       = 7;
    static const uint TRANSPARENT = 8;
};

class TTKey
{
  public:
    static const uint k0           = 0;
    static const uint k1           = 1;
    static const uint k2           = 2;
    static const uint k3           = 3;
    static const uint k4           = 4;
    static const uint k5           = 5;
    static const uint k6           = 6;
    static const uint k7           = 7;
    static const uint k8           = 8;
    static const uint k9           = 9;
    static const uint kNextPage    = 10;
    static const uint kPrevPage    = 11;
    static const uint kNextSubPage = 12;
    static const uint kPrevSubPage = 13;
    static const uint kHold        = 14;
    static const uint kTransparent = 15;
    static const uint kFlofRed     = 16;
    static const uint kFlofGreen   = 17;
    static const uint kFlofYellow  = 18;
    static const uint kFlofBlue    = 19;
};

class TeletextPage
{
  public:
    int pagenum, subpagenum;  ///< the wanted page number
    int lang;                 ///< language code
    int flags;                ///< misc flags
    uint8_t data[25][40];     ///< page data
    int flof;                 ///< page has FastText links
    int floflink[6];          ///< FastText links (FLOF)
    bool subtitle;            ///< page is subtitle page
};

class TeletextMagazine
{
  public:
    QMutex lock;
    TeletextPage *current_page;
    std::map<int, TeletextPage> pages;
};

class OSDTypeTeletext : public OSDType 
{
    Q_OBJECT
  public:
    OSDTypeTeletext(const QString &name, QRect displayrect, TTFFont *font);
    OSDTypeTeletext(const OSDTypeTeletext &other);
    ~OSDTypeTeletext();

    void Reinit(float wchange, float hchange);

    void Draw(OSDSurface *surface, int fade, int maxfade, int xoff, int yoff);
    
    void SetForegroundColor(int color);
    void SetBackgroundColor(int color);

    void DrawBackground(int x, int y);
    void DrawRect(int x, int y, int dx, int dy);
    void DrawCharacter(int x, int y, QChar ch, int doubleheight = 0);
    void DrawMosaic(int x, int y, int code, int doubleheight);

    void DrawLine(const uint8_t* page, uint row, int lang);
    void DrawHeader(const uint8_t* page, int lang);
    void DrawPage(void);

    void NewsFlash(void) {};

    void AddPageHeader(int page, int subpage, const uint8_t *buf, int vbimode);
    void AddTeletextData(int magazine, int row, const uint8_t* buf, int vbimode);
    
    void SetLanguage(int lang);
    void SetFlags(int flags);

    void PageUpdated(int page);
    void HeaderUpdated(uint8_t* page, int lang);

    void KeyPress(uint key);

  private:
    QMutex       m_lock;
    QRect        m_displayrect;

    TTFFont     *m_font;
    OSDSurface  *m_surface;
    OSDTypeBox  *m_box;

    int          m_tt_colspace;
    int          m_tt_rowspace;

    uint8_t      m_bgcolor_y;
    uint8_t      m_bgcolor_u;
    uint8_t      m_bgcolor_v;
    uint8_t      m_bgcolor_a;

    // currently fetching page:
    int m_currentpage;
    int m_currentsubpage;

    // currently displayed page:
    int m_curpage;
    int m_cursubpage;
    int m_pageinput[3];
    bool m_curpage_showheader;
    bool m_transparent;

    TeletextMagazine m_magazines[8];
    unsigned char    bitswap[256];
    
    char CharConversion(char ch, int lang);
    TeletextPage* FindPage(int page, int subpage);

    static const uint COLS = 40;
    static const uint ROWS = 25;
};

#endif

