
#ifndef OSD_TYPE_TELETEXT_H_
#define OSD_TYPE_TELETEXT_H_

#include <qstring.h>
#include <qrect.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <vector>
#include <qobject.h>
#include <qcolor.h>

#include "osdtypes.h"
#include "vbidecoder.h"

using namespace std;

class TTFFont;
class OSDType;
class OSDSurface;
class TV;

class OSDTypeTeletext
    : public TeletextView, public OSDType
{
    Q_OBJECT

  public:
    OSDTypeTeletext(const QString &name, QRect displayrect, TTFFont *font);
    OSDTypeTeletext(const OSDTypeTeletext &other);
    ~OSDTypeTeletext();

    void Reinit(float wchange, float hchange);

    void Draw(OSDSurface *surface, int fade, int maxfade, int xoff, int yoff);

    virtual void setForegroundColor(int color);
    virtual void setBackgroundColor(int color);

    virtual void drawBackground(int x, int y, bool transparent = false);
    virtual void drawRect(int x, int y, int dx, int dy);
    virtual void drawCharacter(int x, int y, QChar ch, int doubleheight = 0);
    virtual void drawMosaic(int x, int y, int code, int doubleheight);

    virtual void newsFlash(void) {};

  signals:
    void Changed(void);
    void headerChanged(void);
    
  protected slots:
    virtual void pageUpdated(int page);
    virtual void headerUpdated(uint8_t* page, int lang);

  private:
    QRect m_displayrect;

    TTFFont *m_font;
    OSDSurface *m_surface;
    OSDTypeBox *m_box;

    int m_tt_colspace;
    int m_tt_rowspace;

    uint8_t m_bgcolor_y;
    uint8_t m_bgcolor_u;
    uint8_t m_bgcolor_v;
    uint8_t m_bgcolor_a;
};

#endif

