use File::Basename;
use DBI;
use LWP::UserAgent;
use Sys::Hostname;

print "Amazon AlbumArt Scraper\n";
print "=======================\n";


my $hostname = hostname;
print "[+] Hostname Found: $hostname\n";
my $dbh = DBI->connect('dbi:mysql:database=mythconverg;host=localhost;', 'root', '') || die "[-] Cannot connect to DB\n";
$dbh->{'mysql_auto_reconnect'}=1;
my $sth = $dbh->prepare("select data from settings where value = 'MusicLocation' and hostname = ?") || die "[-] Cannot prepare SQL statement 1\n";;
my $sth1 = $dbh->prepare("select distinct music_songs.album_id,album_name, artist_name from music_songs, music_albums, music_artists where music_songs.artist_id = music_artists.artist_id and music_songs.album_id = music_albums.album_id order by rand()") || die "[-] Cannot prepare SQL statement 2\n";
my $sth2 = $dbh->prepare("select filename from music_songs where album_id = ? limit 1") || die "[-] Cannot prepare SQL statement 3\n";
my $ua = LWP::UserAgent->new( agent => "" ) or die "[-] Cannot Create UserAgent\n";


$sth->execute($hostname) || die "[-] Error Fetching MythMusic Directory\n";
my $directory = $sth->fetchrow_array;
if ($directory) {
	print "[+] MythMusic Directory found at $directory\n";
} else {
	print "[-] MythMusic Directory not found\n";
	exit;
}
$sth->finish;
my $rows = $sth1->execute;
print "[+] $rows albums found\n";
while (my ($id, $album, $artist) = $sth1->fetchrow_array) {
	my ($imageurl, $filename, $dirname, $searchstring,$amazon_searchstring, $content, $resp, $jpeg) = undef;
	$sth2->execute($id);
	my $filename = $sth2->fetchrow_array;
	my $dirname = dirname($filename);
	print "[+] Fetching on $album by $artist...\t";
	my $searchstring = "$artist+$album";
	$searchstring =~ s/ /+/g;
	my $amazon_searchstring = "http://www.amazon.com/s/?initialSearch=1&url=search-alias%3Dpopular&field-keywords=$searchstring&Go.x=0&Go.y=0&Go=Go";
	my $resp = $ua->get("$amazon_searchstring");
	unless ($resp->is_success) {
		print "[-] Error Searching Amazon For Album. Exiting...\n";
		next;
	}
	$content = $resp->content;
	if ($content =~ /did not match any/) {
		print "Not Found. Next...\n";
		next;
	}
	while ($content =~ /class\="resultCount\">Showing (\d+) Result/igm){
		$results = $1;
	}
	print "$results Results\n";
	if ($content =~ /<a href\=\"(.+?)\"><span class\=\"srTitle\">/ig) {
		$albumurl = $1;
	}
	$resp = $ua->get("$albumurl") || sub{ print "[-] Cannot Fetch Album Info\n";next;};
	$content = $resp->content;
	while ($content =~ /registerImage\(\"original_image\",.\"(.+?)"/igm) {
		$imageurl = $1;
		$imageurl =~ s/AA240/SS500/;
	}
	if ($imageurl) {
		print "[+] Cover Image Found at $imageurl\n";
	} else {
		print "[-] No Cover Image Found\n";
		next;
	}
	$resp = $ua->get("$imageurl");
	$jpeg = $resp->content;
	$filename = "$directory$dirname/albumart.jpg";
	print "[+] Saving to $filename\n";
	open(FILE, ">",  "$filename") || die "[-] Cannot open file: $!\n";
	print FILE $jpeg;
	close(FILE);
	sleep 10;

	
}

$sth1->finish;
$sth2->finish;
$dbh->disconnect;
