#!/usr/bin/perl
### win32-packager.pl 
### Tool for automating frontend builds on MS WIndows XP (and compatible)
### based loosely on osx-packager.pl

use strict;
#use Getopt::Long qw(:config auto_abbrev);
#use Pod::Usage ();
#use Cwd ();
use LWP::UserAgent;
use IO::File;
use Data::Dumper; 

$| = 1; # autoflush stdout;

# TODO We should try to auto-locate the Subversion client binaries, and use them to 'svn up' the mythtv code.
# If they are not in your path, we build them from source
#my $svn = `which svn`; chomp $svn;
#die "must have svn installed and in path" if $svn eq '';

# TODO - we should really allow SF to tell us which server to download from, rather than assuming specific server/s
# currently, I have just used a scattering of different servers about the place so as to not 'load-up' a specific server.
# my $sourceforge = 'http://downloads.sourceforge.net';

# At the moment, there is mythtv plus these two
my @components = ( 'mythtv', 'myththemes', 'mythplugins' );

#TODO - when the 'patch' code gets written, we might be able to have the patches located in a structure like this:?
# Patches for MythTV source
my $patches = {
	'mythtv' => '',
	'QT1' => '',
	'QT2' => '',
};

# TODO - we should try to autodetect these paths, rather than assuming the defaults - perhaps from environment variables like this:
#die "must have env variable SOURCES pointing to your sources folder" unless $ENV{SOURCES};
#my $sources = $ENV{SOURCES};
my $sources = 'C:/msys/1.0/sources/'; # must end in slash 
my $msys = 'C:/MSys/1.0/'; # must end in slash 
my $mingw = 'C:/MinGW/'; # must end in slash 

$ENV{SOURCES} = $sources;

#NOTE: ITS IMPORTANT THAT ALL PATHS TO use FORWARD SLASHES in the declarations below, the code depends on it.

# NOTE:  The architecture of this script is based on cause-and-event.  
#        There are a number of "causes" (or expectations) that can trigger an event/action.
#        There are a number of different actions that can be taken.
#
# eg: [ dir  => "c:/MinGW", exec => $sources.'MinGW-5.1.3.exe' ],
# means: expect there to be a dir called "c:/MinGW", and if there isn't execute the file MinGW-5.1.3.exe.
# (clearly there needs to be a file MinGW-5.1.3.exe on disk for that to work, so there is an earlier declaration to 'fetch' it)


#build expectations (causes) :
#  missing a file (given an expected path)                            [file]
#  missing folder                                                     [dir]
#others we might need:
#  out-of-date file  (compared to another file date)                  not-yet-impl
#  text missing from a file ( perlregex?)                             not-yet-impl


#build actions (events) are:
#  fetch a file from the web (to a location)                         [fetch]
#  set an environment variable (name, value pair)                    not-yet-impl
#  execute a DOS/Win32 exe/command and wait to complete              [exec]
#  execute a MSYS/Unix script/command  and wait to complete          [shell]
#  extract a .tar .tar.gz or .tar.bz2 or ,zip file ( to a location)  [archive] - look for files with the given prefix! (so that .gz and .bz2 are thought equivalent)
#others we might need:
#  copy a file or set of files (path/filespec,  destination)         not-yet-impl.  use exec => 'copy xxx yyy'
#  apply a diff                                                      not-yet-impl
#  search-replace text in a file                                     not-yet-impl


# NOTES on specific actions:
# 'extract' requires a msys unix path as the destination folder, if supplied.  If not supplied, it extracts into the folder the .tar.gz is in.
# 'exec' actually runs all your commands inside a bash shell with -c "( cmd;cmd;cmd )" so be careful about quoting.

# DEFINE OUR EXPECTATIONS and the related ACTIONS:
my $expect = [

# download all the files from the web, and save them here:
[ dir => "$sources", exec => "mkdir $sources" ],

# get mingw and addons first, or we can't do [shell] requests!
[ archive => $sources.'MinGW-5.1.3.exe', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/MinGW-5.1.3.exe' ],
#[ archive => $sources.'mingw32-make-3.81-2.tar', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/mingw32-make-3.81-2.tar.gz' ], - not needed if you select it during the MinGW install
[ archive => $sources.'mingw-utils-0.3.tar.gz', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/mingw-utils-0.3.tar.gz' ],

# install MinGW - it will require user interaction, but once completed, will return control to us....
[ dir  => "c:/MinGW", exec => $sources.'MinGW-5.1.3.exe' ], # interactive, supposed to install g++ and ming make too, but people forget to select them? 
[ file  => "c:/MinGW/bin/gcc.exe", exec => $sources.'MinGW-5.1.3.exe' ], # interactive, supposed to install g++ and ming make too, but people forget to select them? 

# get the MSYS and addons
[ archive => $sources.'MSYS-1.0.10.exe', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/MSYS-1.0.10.exe' ] ,
[ archive => $sources.'bash-3.1-MSYS-1.0.11-1.tar.gz', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/bash-3.1-MSYS-1.0.11-1.tar.bz2' ] ,
[ archive => $sources.'zlib-1.2.3-MSYS-1.0.11.tar.gz', 'fetch' => 'http://easynews.dl.sourceforge.net/sourceforge/mingw/zlib-1.2.3-MSYS-1.0.11.tar.bz2' ] ,
[ archive => $sources.'coreutils-5.97-MSYS-1.0.11-snapshot.tar.gz', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/coreutils-5.97-MSYS-1.0.11-snapshot.tar.bz2' ] ,

# install MSYS, it supplies the 'tar' executable, among others:
[ file => $msys.'bin/tar.exe', 'exec' => $sources.'MSYS-1.0.10.exe' ] , # installer, you should follow prompts, AND do post-install in DOS box.

# prior to this point you can't use the 'extract' feature, or the 'shell' feature!

# if you did a default-install of MingW, then you need to try again, as we really need g++ and mingw32-make, and g77 is needed for fftw
[ file => $mingw.'bin/mingw32-make.exe',  exec => $sources.'MinGW-5.1.3.exe' ],
[ file => $mingw.'bin/g++.exe', exec => $sources.'MinGW-5.1.3.exe' ],
[ file => $mingw.'bin/g77.exe', exec => $sources.'MinGW-5.1.3.exe' ],

#[ file => 'C:/MinGW/bin/mingw32-make.exe',  extract => $sources.'mingw32-make-3.81-2.tar',"C:/MinGW" ], - optionally we could get mingw32-make from here

# now that we have the 'extract' feature, we can finish all the mingw and msys addons:
[ file => $mingw.'/bin/reimp.exe',  extract => $sources.'mingw-utils-0.3.tar', $mingw ],
[ file => $msys.'bin/bash.exe',  extract => $sources.'bash-3.1-MSYS-1.0.11-1.tar', "/" ],

# the zlib download is a bit messed-up, and needs some TLC to put everything in the right place:
[ dir => $sources."zlib" ,  exec => "mkdir $sources/zlib" ],
[ dir => $sources."zlib/usr",  extract => $sources.'zlib-1.2.3-MSYS-1.0.11.tar', $sources."zlib" ],
[ file => $msys.'lib/libz.a',  exec => "copy $sources/zlib/usr/lib/* $msys/lib/" ],
[ file => $msys.'bin/msys-z.dll',  exec => "copy $sources/zlib/usr/bin/* $msys/bin/" ],
[ file => $msys.'include/zlib.h',  exec => "copy $sources/zlib/usr/include/* $msys/include/" ],

# fetch mysql
[ file => $sources.'mysql-essential-5.0.45-win32.msi', 'fetch' => 'http://dev.mysql.com/get/Downloads/MySQL-5.0/mysql-essential-5.0.45-win32.msi/from/http://mysql.mirrors.ilisys.com.au/' ],
# TODO after install (not done yet)
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/include/* /c/MinGW/include/
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/bin/libmySQL.dll /c/MinGW/lib
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/lib/opt/libmysql.lib /c/MinGW/lib

# libpthread is precompiled, just download it to the right place (does this work?)
[ archive => $mingw.'lib/libpthread.a', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/lib/libpthreadGC2.a' ],
[ archive => $mingw.'bin/pthreadGC2.dll', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/lib/pthreadGC2.dll' ],
[ file => $mingw.'bin/pthread.dll', exec => "cd $mingw/bin && copy $mingw/bin/pthreadGC2.dll pthread.dll" ],
[ archive => $mingw.'include/pthread.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/pthread.h' ],
[ archive => $mingw.'include/sched.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/sched.h' ],
[ archive => $mingw.'include/semaphore.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/semaphore.h' ],

# download the MS directX SDK
[ archive => $sources.'dxsdk_november2007.exe','fetch' => 'http://www.microsoft.com/downloads/info.aspx?na=90&p=&SrcDisplayLang=en&SrcCategoryId=&SrcFamilyId=4b78a58a-e672-4b83-a28e-72b5e93bd60a&u=http%3a%2f%2fdownload.microsoft.com%2fdownload%2fb%2fe%2f7%2fbe7ffe34-903c-410b-bdbc-ee6c018df45c%2fdxsdk_november2007.exe' ],

# now we do each of the source library dependancies in turn: download,extract,build/install
# TODO - ( and just prey that they all work?)  These should really be more detailed, and actually check that we got it installed properly.

# Most of these look for a Makefile as a sign that the ./configure was successful (not necessarily true, but it's a start)
# but this requires that the .tar.gz didn't come with a Makefile in it.

[ archive => $sources.'SDL-1.2.12.tar.gz',  fetch => 'http://www.libsdl.org/release/SDL-1.2.12.tar.gz'],
[ dir => $sources.'SDL-1.2.12', extract => $sources.'SDL-1.2.12.tar.gz' ],
[ file => $sources.'SDL-1.2.12/Makefile', shell => "cd $sources/SDL-1.2.12","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'fftw-3.1.2.tar.gz',  fetch => 'http://www.fftw.org/fftw-3.1.2.tar.gz'],
[ dir => $sources.'fftw-3.1.2', extract => $sources.'fftw-3.1.2.tar' ],
[ file => $sources.'fftw-3.1.2/Makefile', shell => "cd $sources/fftw-3.1.2","./configure --prefix=/mingw","make","make install" ],

[ archive => $sources.'flac-1.2.1.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/flac/flac-1.2.1.tar.gz'],
[ dir => $sources.'flac-1.2.1', extract => $sources.'flac-1.2.1.tar' ],
[ file => $mingw.'include/limits.h_', shell => "echo \\#define SIZE_T_MAX UINT_MAX >> $mingw/include/limits.h","touch $mingw/include/limits.h_" ], 
[ file => $sources.'flac-1.2.1/Makefile', shell => "cd $sources/flac-1.2.1","./configure --prefix=/mingw","make","make install" ],


[ archive => $sources.'freetype-2.3.5.tar.gz',  fetch => 'http://download.savannah.nongnu.org/releases/freetype/freetype-2.3.5.tar.gz'],
[ dir => $sources.'freetype-2.3.5', extract => $sources.'freetype-2.3.5.tar' ],
# caution... freetype comes with a Makefile in the .tar.gz, so work around it!
[ file => $sources.'freetype-2.3.5/Makefile_', shell => "cd $sources/freetype-2.3.5","./configure --prefix=/mingw","make","make install","touch $sources/freetype-2.3.5/Makefile_" ],


[ archive => $sources.'lame-3.97.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/lame/lame-3.97.tar.gz'],
[ dir => $sources.'lame-3.97', extract => $sources.'lame-3.97.tar' ],
[ file => $sources.'lame-3.97/Makefile', shell => "cd $sources/lame-3.97","./configure --prefix=/mingw","make","make install" ],


[ archive => $sources.'libao-0.8.8.tar.gz',  fetch => 'http://downloads.xiph.org/releases/ao/libao-0.8.8.tar.gz'],
[ dir => $sources.'libao-0.8.8', extract => $sources.'libao-0.8.8.tar' ],
[ file => $sources.'libao-0.8.8/Makefile', shell => "cd $sources/libao-0.8.8","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libexif-0.6.16.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/libexif/libexif-0.6.16.tar.gz'],
[ dir => $sources.'libexif-0.6.16', extract => $sources.'libexif-0.6.16.tar' ],
[ file => $sources.'libexif-0.6.16/Makefile', shell => "cd $sources/libexif-0.6.16","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libmad-0.15.1b.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/mad/libmad-0.15.1b.tar.gz'],
[ dir => $sources.'libmad-0.15.1b', extract => $sources.'libmad-0.15.1b.tar' ],
[ file => $sources.'libmad-0.15.1b/Makefile', shell => "cd $sources/libmad-0.15.1b","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libogg-1.1.3.tar.gz',  fetch => 'http://downloads.xiph.org/releases/ogg/libogg-1.1.3.tar.gz'],
[ dir => $sources.'libogg-1.1.3', extract => $sources.'libogg-1.1.3.tar' ],
[ file => $sources.'libogg-1.1.3/Makefile', shell => "cd $sources/libogg-1.1.3","./configure --prefix=/usr","make","make install" ],

[ archive => $sources.'libvisual-0.4.0.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/libvisual/libvisual-0.4.0.tar.gz'],
[ dir => $sources.'libvisual-0.4.0', extract => $sources.'libvisual-0.4.0.tar' ],
[ file => $sources.'libvisual-0.4.0/Makefile', shell => "cd $sources/libvisual-0.4.0","./configure --prefix=/usr","make","make install" ],

[ archive => $sources.'libvorbis-1.2.0.tar.gz',  fetch => 'http://downloads.xiph.org/releases/vorbis/libvorbis-1.2.0.tar.gz'],
[ dir => $sources.'libvorbis-1.2.0', extract => $sources.'libvorbis-1.2.0.tar' ],
[ file => $sources.'libvorbis-1.2.0/Makefile', shell => "cd $sources/libvorbis-1.2.0","./configure --prefix=/usr --disable-shared","make","make install" ],

#[ archive => $sources.'pthreads-w32-2-8-0-release.tar.gz',  fetch => 'ftp://sourceware.org/pub/pthreads-win32/pthreads-w32-2-8-0-release.tar.gz'],
#[ dir => $sources.'pthreads-w32-2-8-0-release', extract => $sources.'pthreads-w32-2-8-0-release.tar' ],

[ archive => $sources.'taglib-1.4.tar.gz',  fetch => 'http://developer.kde.org/~wheeler/files/src/taglib-1.4.tar.gz'],
[ dir => $sources.'taglib-1.4', extract => $sources.'taglib-1.4.tar' ],
[ file => $sources.'taglib-1.4/Makefile', shell => "cd $sources/taglib-1.4","./configure --prefix=/usr","make","make install" ],
# TODO tweak makefiles:
# INSTALL = C:/msys/1.0/bin/install -c -p
# INSTALL = ../C:/msys/1.0/bin/install -c -p
# INSTALL = ../../C:/msys/1.0/bin/install -c -p

[ archive => $sources.'tiff-3.8.2.tar.gz',  fetch => 'ftp://ftp.remotesensing.org/pub/libtiff/tiff-3.8.2.tar.gz'],
[ dir => $sources.'tiff-3.8.2', extract => $sources.'tiff-3.8.2.tar' ],
[ file => $sources.'tiff-3.8.2/Makefile', shell => "cd $sources/tiff-3.8.2","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'qt-3.3.x-p8.tar.bz2',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/qtwin/qt-3.3.x-p8.tar.bz2'],
[ dir => 'C:/msys/1.0/qt-3.3.x-p8', extract => $sources.'qt-3.3.x-p8.tar', 'C:/msys/1.0/qt-3.3.x-p8' ],
# TODO  - patch the QT sources
# TODO  - build the QT sources 

# typical template:
#[ archive => $sources.'xxx.tar.gz',  fetch => ''],
#[ dir => $sources.'xxx', extract => $sources.'xxx.tar' ],
#[ file => $sources.'xxx/Makefile', shell => "cd $sources/xxx","./configure --prefix=/usr","make","make install" ],

# more !

# unzip tool  - precompiled native Win32 version from InfoZip  (alternate would be from the gnuwin32 project, which is actually from same source)
#  run it into a 'unzip' folder, becuase it doesn't extract to a folder:
[ dir => $sources."unzip" ,  exec => "mkdir $sources/unzip" ],
[ archive => $sources.'unzip/unz552xN.exe',  fetch => 'ftp://tug.ctan.org/tex-archive/tools/zip/info-zip/WIN32/unz552xN.exe'],
[ file => $sources.'unzip/unzip.exe', exec => $sources.'unzip/unz552xN.exe', $sources.'unzip/' ],

# this comes as a zip file, so it can't be done earlier than the unzip tool! 
[ archive => $sources.'svn-win32-1.4.6.zip',  fetch => 'http://subversion.tigris.org/files/documents/15/41077/svn-win32-1.4.6.zip'],
[ dir => $sources.'svn-win32-1.4.6', extract => $sources.'svn-win32-1.4.6.zip' ],
#[ file => $sources.'svn-win32-1.4.6/bin/svn.exe', shell => "cd $sources/xxx","./configure --prefix=/usr","make","make install" ],


];


# this is the mainloop that itterates over the above definitions and determines what to do:
# cause:
foreach my $dep ( @{$expect} ) { 
	my @dep = @{$dep};
	
	#print Dumper(\@dep);
	
	my $causetype = $dep[0];
	my $cause =  $dep[1];
	
	my $effecttype = $dep[2];
	my @effectparams = @dep[3..$#dep];
	
	if ( $causetype eq 'archive' ) {
		die unless $effecttype eq 'fetch';
		   if ( -f $cause ) {print "file exists: $cause\n"; next;}		
		effect($effecttype,$cause,@effectparams); # 2nd and 3rd params get squashed into a single array on passing to effect();
		#_fetch($cause,@effectparams);
		   if ( ! -f $cause ) {die "EFFECT FAILED: $causetype,$cause,$effecttype\n";}	
		
	}	elsif ( $causetype eq 'dir' ) {
		   if ( -d $cause ) {print "directory exists: $causetype,$cause\n";	next;}
		effect($effecttype,@effectparams);
		   if ( ! -d $cause ) {die "EFFECT FAILED: $causetype,$cause,$effecttype\n";}	
		
	} elsif ( $causetype eq 'file' ) {
		   if ( -f $cause ) {print "file exists: $cause\n"; next;}		
		effect($effecttype,@effectparams);
		   if ( ! -f $cause ) {die "EFFECT FAILED: $causetype,$cause,$effecttype\n";}	
		   
	} else {
		die " unknown causetype $causetype \n";
	}
}

# each cause has an effect, this is where we do them:
sub effect {
	my ( $effecttype, @effectparams ) = @_;
	
	  if ( $effecttype eq 'fetch') {
	  	_fetch(@effectparams); # passing two parameters that came in via the array
	  	
		} elsif ( $effecttype eq 'extract') {
			my $tarfile = $effectparams[0];
			my $destdir = $effectparams[1] || '';
			if ($destdir eq '') {
				$destdir = $tarfile;
				$destdir =~ s#[^/]*$##; # strip off everything after the final forward slash
			}
			my $t = findtar($tarfile);
			print "found equivalent: ($t) -> ($tarfile)\n" if $t ne $tarfile;
			print "extracttar($t,$destdir);\n";
			extracttar($t,$destdir);
			
		} elsif ($effecttype eq 'exec') { # execute a DOS command
			my $cmd = shift @effectparams;
			$cmd =~ s#/#\\#g; # convert all forward to SINGLE backward slashes ( TODO - might be overkill to do all slashes ? )

			#print `$cmd`;
			print "cmd:$cmd\n";
			open F, "$cmd |"  || die "err: $!";
			while (<F>) {
	  		print;
			}   
			
		} elsif ($effecttype eq 'shell') {
    	shell(@effectparams);
    	
		} else {
				die " unknown effecttype $effecttype from cause 'dir'\n";
	  }
}

# kinda like a directory search for blah.tar* but faster/easier.  only finds .tar.gz, .tar.bz2, .zip
sub findtar {
	my $t = shift;
	return "$t.gz" if -f "$t.gz";
	return "$t.bz2" if -f "$t.bz2";
	
	if ( -f "$t.zip" || $t =~ m/\.zip$/ ) {
		die "no unzip.exe found ! - yet" unless -f $sources."unzip/unzip.exe"; # TODO - a bit of a special test, should be fixed better.
		return "$t.zip" if  -f "$t.zip";
		return $t if -f $t;
	}
	return $t if -f $t;
	return undef;
}


# given a ($t) .tar.gz, .tar.bz2, .zip extract it to the directory ( $d)
# changes current directory to $d too
sub extracttar {
	my ( $t, $d) = @_;

  unless ( $t =~ m/zip/ ) {
    $t =~ s#^C:/MSys/1.0##i;
  }
	my $d2 = $d; 
	$d2 =~ s#/#\\\\#g;
			
	print "extracting to: $d\n";	
	my $cmd = '';	
	if ( $t =~ /\.gz$/ ) {
		$cmd = "chdir $d2 && c:/msys/1.0/bin/tar.exe -zxvpf $t";
	} elsif ( $t =~ /\.bz2$/ ) {
		$cmd = "chdir $d2 && c:/msys/1.0/bin/tar.exe -jxvpf $t";
	}elsif ( $t =~ /\.zip$/ ) {
		$cmd = "chdir $d2 && $sources/unzip/unzip.exe -o $t";
		#die "unzippng not implemented yet \n";
	}elsif ( $t =~ /\.tar$/ ) {
		$cmd = "chdir $d2 && c:/msys/1.0/bin/tar.exe -xvpf $t";
	} else {
		die  "extract tar failed on ($t,$d)\n";
	}
	
	# execute the cmd, and capture the output!  
	# this is a glorified version of "print `$cmd`;" except it doesn't buffer the output, if $|=1; is set.
	# $t should be a msys compatible path ie /sources/etc
	print "cmd:$cmd\n";
	open F, "$cmd |"  || die "err: $!";
	while (<F>) {
	  print;
	}   
}


# get the $url (typically a .tar.gz or similar) , and save it to $file
sub _fetch {
	my ( $file,$url ) = @_;
	
	#$file =~ s#/#\\\\#g;
	print "already exists: $file \n" if -f $file;
	return undef if -f $file;
	
	print "fetching $url to $file...\n";
	  my $ua = LWP::UserAgent->new;
	  my $req = HTTP::Request->new(GET => "$url");
    my $res = $ua->request($req);
    if ($res->is_success) {
    	my $f = new IO::File "> $file" || die "_fetch: $!\n";
    	$f->binmode();
      $f->print($res->content);
      $f->close();
    }
}


# execute a sequence of commands in a bash shell.
# we explicitly add the /bin and /mingw/bin to the path because at this point they aren't likely to be there (cause we are in the process of installing them)
sub shell {
	my @cmds = @_;
	
	my $cmd = $msys.'bin/bash.exe -c "( export PATH=/bin:/mingw/bin:$PATH;'.join(';',@cmds).')"';	
	
	# execute the cmd, and capture the output!  this is a glorified version of "print `$cmd`;" except it doesn't buffer the output if $|=1; is set.
	open F, "$cmd |"  || die "err: $!";
	while (<F>) {
	print;
	}
	
}
