#!/usr/bin/perl


### win32-packager.pl 
### Tool for automating frontend builds on MS WIndows XP (and compatible)
### based loosely on osx-packager.pl

use strict;
#use Getopt::Long qw(:config auto_abbrev);
#use Pod::Usage ();
#use Cwd ();
use LWP::UserAgent;
use IO::File;
use Data::Dumper; 

# We try to auto-locate the Subversion client binaries.
# If they are not in your path, we build them from source
#
#my $svn = `which svn`; chomp $svn;
#die "must have svn installed and in path" if $svn eq '';

my $sourceforge = 'http://downloads.sourceforge.net';

# At the moment, there is mythtv plus these two
my @components = ( 'mythtv', 'myththemes', 'mythplugins' );

# Patches for MythTV source
my $patches = {
	'mythtv' => '',
	'QT' => '',
	
};

#die "must have env variable SOURCES pointing to your sources folder" unless $ENV{SOURCES};
#my $sources = $ENV{SOURCES};
my $sources = 'C:/msys/1.0/sources/'; # must end in slash 
my $msys = 'C:/MSys/1.0/'; # must end in slash 
my $mingw = 'C:/MinGW/'; # must end in slash 

$ENV{SOURCES} = $sources;

#NOTE: ALL PATHS TO use FORWARD SLASHES! 

# 'extract' requires a msys unix path as the destination folder, if supplied at all.

# build causes:
# missing file (given an expected path)
# missing folder                                                     [dir]
# out-of-date file  (compared to another file date)
# text missing from a file ( perlregex?)


# build actions are:
# fetch a file from the web (to a location)                         [fetch]
# set an environment variable (name, value pair)
# execute a script/exe (path to script, cwd) and wait to complete
# copy a file or set of files (path/filespec,  destination)
# extract a .tar .tar.gz or .tar.bz2 or ,zip file ( to a location)  [archive] - must look for files with the given prefix! (so that .gz and .bz2 are thought equivalent)
# apply a diff 
# search-replace text in a file

#sources:
my $expect = [
[ dir => "$sources", exec => "mkdir $sources" ],

[ archive => $sources.'MinGW-5.1.3.exe', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/MinGW-5.1.3.exe' ],
#[ archive => $sources.'mingw32-make-3.81-2.tar', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/mingw32-make-3.81-2.tar.gz' ],
[ archive => $sources.'mingw-utils-0.3.tar.gz', 'fetch' => 'http://superb-west.dl.sourceforge.net/sourceforge/mingw/mingw-utils-0.3.tar.gz' ],

[ dir  => "c:/MinGW", exec => $sources.'MinGW-5.1.3.exe' ], # interactive, supposed to install g++ and ming make too, but people forget to select them? 
[ dir  => "c:/MinGW/bin/gcc.exe", exec => $sources.'MinGW-5.1.3.exe' ], # interactive, supposed to install g++ and ming make too, but people forget to select them? 

[ archive => $sources.'MSYS-1.0.10.exe', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/MSYS-1.0.10.exe' ] ,
[ archive => $sources.'bash-3.1-MSYS-1.0.11-1.tar.gz', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/bash-3.1-MSYS-1.0.11-1.tar.bz2' ] ,
[ archive => $sources.'zlib-1.2.3-MSYS-1.0.11.tar.gz', 'fetch' => 'http://easynews.dl.sourceforge.net/sourceforge/mingw/zlib-1.2.3-MSYS-1.0.11.tar.bz2' ] ,
[ archive => $sources.'coreutils-5.97-MSYS-1.0.11-snapshot.tar.gz', 'fetch' => 'http://internap.dl.sourceforge.net/sourceforge/mingw/coreutils-5.97-MSYS-1.0.11-snapshot.tar.bz2' ] ,

# prior to this point you can't use the 'extract' feature:
[ file => 'c:/msys/1.0/bin/tar.exe', 'exec' => $sources.'MSYS-1.0.10.exe' ] , # installer, you should follow prompts, AND do post-install in DOS box.

[ file => $mingw.'bin/mingw32-make.exe',  exec => $sources.'MinGW-5.1.3.exe' ],
[ file => $mingw.'bin/g++.exe', exec => $sources.'MinGW-5.1.3.exe' ],
#[ file => 'C:/MinGW/bin/mingw32-make.exe',  extract => $sources.'mingw32-make-3.81-2.tar',"C:/MinGW" ],

[ file => $mingw.'/bin/reimp.exe',  extract => $sources.'mingw-utils-0.3.tar', $mingw ],

[ file => $msys.'bin/bash.exe',  extract => $sources.'bash-3.1-MSYS-1.0.11-1.tar', "/" ],

[ dir => $sources."zlib" ,  exec => "mkdir $sources/zlib" ],
[ dir => $sources."zlib/usr",  extract => $sources.'zlib-1.2.3-MSYS-1.0.11.tar', $sources."zlib" ],

[ file => $msys.'lib/libz.a',  exec => "copy $sources/zlib/usr/lib/* $msys/lib/" ],
[ file => $msys.'bin/msys-z.dll',  exec => "copy $sources/zlib/usr/bin/* $msys/bin/" ],
[ file => $msys.'include/zlib.h',  exec => "copy $sources/zlib/usr/include/* $msys/include/" ],

[ file => $sources.'mysql-essential-5.0.45-win32.msi', 'fetch' => 'http://dev.mysql.com/get/Downloads/MySQL-5.0/mysql-essential-5.0.45-win32.msi/from/http://mysql.mirrors.ilisys.com.au/' ],
# after install
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/include/* /c/MinGW/include/
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/bin/libmySQL.dll /c/MinGW/lib
# cp /c/Program\ Files/MySQL/MySQL\ Server\ 5.0/lib/opt/libmysql.lib /c/MinGW/lib

# libpthread is precompiled, just download it!
[ archive => $mingw.'lib/libpthread.a', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/lib/libpthreadGC2.a' ],
[ archive => $mingw.'bin/pthreadGC2.dll', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/lib/pthreadGC2.dll' ],
[ file => $mingw.'bin/pthread.dll', exec => "copy $mingw/bin/pthreadGC2.dll $mingw/bin/pthread.dll " ],
[ archive => $mingw.'include/pthread.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/pthread.h' ],
[ archive => $mingw.'include/sched.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/sched.h' ],
[ archive => $mingw.'include/semaphore.h', 'fetch' => 'ftp://sources.redhat.com/pub/pthreads-win32/dll-latest/include/semaphore.h' ],

[ archive => $sources.'dxsdk_november2007.exe','fetch' => 'http://www.microsoft.com/downloads/info.aspx?na=90&p=&SrcDisplayLang=en&SrcCategoryId=&SrcFamilyId=4b78a58a-e672-4b83-a28e-72b5e93bd60a&u=http%3a%2f%2fdownload.microsoft.com%2fdownload%2fb%2fe%2f7%2fbe7ffe34-903c-410b-bdbc-ee6c018df45c%2fdxsdk_november2007.exe' ],

[ archive => $sources.'SDL-1.2.12.tar.gz',  fetch => 'http://www.libsdl.org/release/SDL-1.2.12.tar.gz'],
[ dir => $sources.'fftw-3.1.2', extract => $sources.'SDL-1.2.12.tar.gz' ],
[ file => $sources.'fftw-3.1.2/Makefile', shell => "cd $sources/fftw-3.1.2","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'fftw-3.1.2.tar.gz',  fetch => 'http://www.fftw.org/fftw-3.1.2.tar.gz'],
[ dir => $sources.'fftw-3.1.2', extract => $sources.'fftw-3.1.2.tar' ],
[ file => $sources.'fftw-3.1.2/Makefile', shell => "cd $sources/fftw-3.1.2","./configure --prefix=/mingw","make","make install" ],

[ archive => $sources.'flac-1.2.1.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/flac/flac-1.2.1.tar.gz'],
[ dir => $sources.'flac-1.2.1', extract => $sources.'flac-1.2.1.tar' ],
[ file => $mingw.'include/limits.h_', shell => "echo \\#define SIZE_T_MAX UINT_MAX >> $mingw/include/limits.h","touch $mingw/include/limits.h_" ], 
[ file => $sources.'flac-1.2.1/Makefile', shell => "cd $sources/flac-1.2.1","./configure --prefix=/mingw","make","make install" ],


[ archive => $sources.'freetype-2.3.5.tar.gz',  fetch => 'http://download.savannah.nongnu.org/releases/freetype/freetype-2.3.5.tar.gz'],
[ dir => $sources.'freetype-2.3.5', extract => $sources.'freetype-2.3.5.tar' ],
# caution... freetype comes with a Makefile
[ file => $sources.'freetype-2.3.5/Makefile_', shell => "cd $sources/freetype-2.3.5","./configure --prefix=/mingw","make","make install","touch $sources/freetype-2.3.5/Makefile_" ],


[ archive => $sources.'lame-3.97.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/lame/lame-3.97.tar.gz'],
[ dir => $sources.'lame-3.97', extract => $sources.'lame-3.97.tar' ],
[ file => $sources.'lame-3.97/Makefile', shell => "cd $sources/lame-3.97","./configure --prefix=/mingw","make","make install" ],


[ archive => $sources.'libao-0.8.8.tar.gz',  fetch => 'http://downloads.xiph.org/releases/ao/libao-0.8.8.tar.gz'],
[ dir => $sources.'libao-0.8.8', extract => $sources.'libao-0.8.8.tar' ],
[ file => $sources.'libao-0.8.8/Makefile', shell => "cd $sources/libao-0.8.8","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libexif-0.6.16.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/libexif/libexif-0.6.16.tar.gz'],
[ dir => $sources.'libexif-0.6.16', extract => $sources.'libexif-0.6.16.tar' ],
[ file => $sources.'libexif-0.6.16/Makefile', shell => "cd $sources/libexif-0.6.16","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libmad-0.15.1b.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/mad/libmad-0.15.1b.tar.gz'],
[ dir => $sources.'libmad-0.15.1b', extract => $sources.'libmad-0.15.1b.tar' ],
[ file => $sources.'libmad-0.15.1b/Makefile', shell => "cd $sources/libmad-0.15.1b","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'libogg-1.1.3.tar.gz',  fetch => 'http://downloads.xiph.org/releases/ogg/libogg-1.1.3.tar.gz'],
[ dir => $sources.'libogg-1.1.3', extract => $sources.'libogg-1.1.3.tar' ],
[ file => $sources.'libogg-1.1.3/Makefile', shell => "cd $sources/libogg-1.1.3","./configure --prefix=/usr","make","make install" ],

[ archive => $sources.'libvisual-0.4.0.tar.gz',  fetch => 'http://optusnet.dl.sourceforge.net/sourceforge/libvisual/libvisual-0.4.0.tar.gz'],
[ dir => $sources.'libvisual-0.4.0', extract => $sources.'libvisual-0.4.0.tar' ],
[ file => $sources.'libvisual-0.4.0/Makefile', shell => "cd $sources/libvisual-0.4.0","./configure --prefix=/usr","make","make install" ],

[ archive => $sources.'libvorbis-1.2.0.tar.gz',  fetch => 'http://downloads.xiph.org/releases/vorbis/libvorbis-1.2.0.tar.gz'],
[ dir => $sources.'libvorbis-1.2.0', extract => $sources.'libvorbis-1.2.0.tar' ],
[ file => $sources.'libvorbis-1.2.0/Makefile', shell => "cd $sources/libvorbis-1.2.0","./configure --prefix=/usr --disable-shared","make","make install" ],

#[ archive => $sources.'pthreads-w32-2-8-0-release.tar.gz',  fetch => 'ftp://sourceware.org/pub/pthreads-win32/pthreads-w32-2-8-0-release.tar.gz'],
#[ dir => $sources.'pthreads-w32-2-8-0-release', extract => $sources.'pthreads-w32-2-8-0-release.tar' ],

[ archive => $sources.'taglib-1.4.tar.gz',  fetch => 'http://developer.kde.org/~wheeler/files/src/taglib-1.4.tar.gz'],
[ dir => $sources.'taglib-1.4', extract => $sources.'taglib-1.4.tar' ],
[ file => $sources.'taglib-1.4/Makefile', shell => "cd $sources/taglib-1.4","./configure --prefix=/usr","make","make install" ],
# tweak makefiles:
# INSTALL = C:/msys/1.0/bin/install -c -p
# INSTALL = ../C:/msys/1.0/bin/install -c -p
# INSTALL = ../../C:/msys/1.0/bin/install -c -p


[ archive => $sources.'tiff-3.8.2.tar.gz',  fetch => 'ftp://ftp.remotesensing.org/pub/libtiff/tiff-3.8.2.tar.gz'],
[ dir => $sources.'tiff-3.8.2', extract => 'tiff-3.8.2.tar' ],
[ file => $sources.'tiff-3.8.2/Makefile', shell => "cd $sources/tiff-3.8.2","./configure --prefix=/usr","make","make install" ],


[ archive => $sources.'qt-3.3.x-p8.tar.gz',  fetch => ''],
[ dir => 'C:/msys/1.0/qt-3.3.x-p8', extract => 'tiff-3.8.2.tar', 'C:/msys/1.0/qt-3.3.x-p8' ],

#[ archive => $sources.'',  fetch => ''],
#[ dir => $sources.'', extract => '' ],


];


foreach my $dep ( @{$expect} ) { 
	my @dep = @{$dep};
	
	#print Dumper(\@dep);
	
	my $causetype = $dep[0];
	my $cause =  $dep[1];
	
	my $effecttype = $dep[2];
	my @effectparams = @dep[3..$#dep];
	
	if ( $causetype eq 'archive' ) {
		
		die unless $effecttype eq 'fetch';
		_fetch($cause,@effectparams);
		
	}	elsif ( $causetype eq 'dir' ) {
		
		if ( -d $cause ) {
			print "directory exists: $cause\n";
			next;
		}
		
		if ( $effecttype eq 'extract') {
			my $tarfile = $effectparams[0];
			my $destdir = $effectparams[1] || '';
			if ($destdir eq '') {
				$destdir = $tarfile;
				$destdir =~ s#[^/]*$##; # strip off everything after the final forward slash
			}
			my $t = findtar($tarfile);
			print "found equivalent: $t" if $t ne $tarfile;
			print "extracttarA($t,$destdir);\n";
			extracttar($t,$destdir);
		} elsif ($effecttype eq 'exec') {
			my $cmd = shift @effectparams;
			print `$cmd`;
		} elsif ($effecttype eq 'shell') {
    	shell(@effectparams);
		} else {
				die " unknown effecttype $effecttype from cause 'dir'\n";
	  }
	
	} elsif ( $causetype eq 'file' ) {
		
				
		if ( -f $cause ) {
			print "file exists: $cause\n";
			next;
		}
		
    if ( $effecttype eq 'extract') {
			my $tarfile = $effectparams[0];
			my $destdir = $effectparams[1] || '';
			if ($destdir eq '') {
				$destdir = $tarfile;
				$destdir =~ s#[^/]*$##; # strip off everything after the final forward slash
			}
			my $t = findtar($tarfile);
			print "found equivalent file: $t" if $t ne $tarfile;
			extracttar($t,$destdir);
		} elsif ($effecttype eq 'exec') {
			my $cmd = shift @effectparams;
			print `$cmd`;
    } elsif ($effecttype eq 'shell') {
    	shell(@effectparams);
		} else {
				die " unknown effecttype $effecttype from cause 'file'\n";
	  }	
	} else {
		die " unknown causetype $causetype \n";
	}
}


sub findtar {
	# kinda like a directory search for blah.tar* but faster.  only finds .tar.gz, .tar.bz2, .zip
	my $t = shift;
	return $t if -f $t;
	return "$t.gz" if -f "$t.gz";
	return "$t.bz2" if -f "$t.bz2";
	return "$t.zip" if -f "$t.zip";
	return undef;
}
# given a ($t) .tar.gz, .tar.bz2, .zip extract it to the directory ( $d)
# changes current directory to $d too.
sub extracttar {
	my ( $t, $d) = @_;
	
		  $t =~ s#^C:/MSys/1.0##i;
			#$d =~ s#^C:/MSys/1.0##i;
			my $d2 = $d; 
			$d2 =~ s#/#\\\\#g;
			
	print "extracting to: $d\n";		
	if ( $t =~ /\.gz$/ ) {
		chdir($d);
		print `chdir $d2 && c:/msys/1.0/bin/tar.exe -zxvpf $t`;
	} elsif ( $t =~ /\.bz2$/ ) {
		chdir($d);
		print `chdir $d2 && c:/msys/1.0/bin/tar.exe -jxvpf $t`;
	}elsif ( $t =~ /\.zip$/ ) {
		die "unzippng not implemented yet\n";
	}elsif ( $t =~ /\.tar$/ ) {
		chdir($d);
		my $cmd = "chdir $d2 && c:/msys/1.0/bin/tar.exe -xvpf $t";
		#print "$cmd\n";
		print `$cmd`;   #$t should be a msys compatible path ie /sources/etc
	} else {
		die  "extract tar failed on ($t,$d)\n";
	}
}


sub _fetch {
	# get the $url (typically a .tar.gz or similar) , and save it to $file
	my ( $file,$url ) = @_;
	
	#$file =~ s#/#\\\\#g;
	print "already exists: $file \n" if -f $file;
	return undef if -f $file;
	
	print "fetching $url to $file\n";
	  my $ua = LWP::UserAgent->new;
	  my $req = HTTP::Request->new(GET => "$url");
    my $res = $ua->request($req);
    if ($res->is_success) {
    	my $f = new IO::File "> $file" || die "_fetch: $!\n";
      $f->print($res->content);
      $f->close();
    }

}

sub shell {
	my @cmds = @_;
	
	my $bash = $msys.'bin/bash.exe -c "( export PATH=/bin:/mingw/bin:$PATH;'.join(';',@cmds).')"';
	print "shell: $bash\n";
	print `$bash`;
}

