#ifndef WEATHERDATA_H_
#define WEATHERDATA_H_
#include <qwidget.h>
#include <qobject.h>

class WeatherData : public QObject
{
    Q_OBJECT

    friend class Weather;

    public:
       WeatherData(class Weather *par = NULL, QString locale = "", int wantAnimated = 0);
       ~WeatherData();
       void setLocation(QString newLocale);
       bool GetBaseData();
       bool GetAnimatedRadarMap();
       bool GetStaticRadarMap();

       bool LoadData();
       bool UpdateBaseData();
    
    private:
        QString locale;
        QString city;
        QString state;
        QString country;
        QString measure;
        QString curTemp;
        QString curIcon;
        QString curWind;
        QString winddir;
        QString barometer;  
        QString curHumid;
        QString curFeel;
        QString uvIndex;
        QString visibility;
        QString updated;
        QString description;
        QString date[5];
        QString weatherIcon[5];
        QString weatherType[5];
        QString highTemp[5];
        QString lowTemp[5];
        QString precip[5];
	int pastTime;

	int wantAnimated;

	QString httpData;


    private:
       bool debug;
       bool convertData;

       class Weather *parent;

       QTimer *urlTimer;
       int weatherTimeoutInt;
       bool stopProcessing;

       QString GetFileName(QString dataType);

       QString parseData(QString data, QString beg, QString end);

       QString GetString(QString);
       int GetInt(QString);
       float GetFloat(QString);

       void InterpretData();

    private slots:
       void weatherTimeout();
};
#endif
