/*
	main.cpp

	(c) 2003 Thor Sigvaldason and Isaac Richards
	Part of the mythTV project
	
	Starting point for the myth transcoding daemon

*/

#include <qapplication.h>
#include <qsqldatabase.h>
#include <qfile.h>
#include <qtextstream.h>

#include <iostream>
using namespace std;
#include <unistd.h>

#include <mythtv/exitcodes.h>
#include <mythtv/mythcontext.h>
#include <mythtv/mythdbcon.h>
#include <mythtv/langsettings.h>

#include "../mythweather/weatherdata.h"

#define MTD_EXIT_DEAMONIZING_ERROR                FRONTEND_EXIT_START-1
#define MTD_EXIT_NO_TRANSCODE_SUPPORT             FRONTEND_EXIT_START-2

int main(int argc, char **argv)
{
    QApplication a(argc, argv, false);
    //
    //  Check command line arguments
    //
    
    gContext = NULL;
    gContext = new MythContext(MYTH_BINARY_VERSION);
    if (!gContext->Init(false))
    {
        cerr << "Could not initialize myth context. Exiting." << endl;
        return FRONTEND_EXIT_NO_MYTHCONTEXT;
    }

    if (!MSqlQuery::testDBConnection())
    {
        cerr << "mtd: Couldn't open database. I go away now. " << endl;
        return FRONTEND_EXIT_DB_ERROR;
    }

    //
    //  Where to log
    //
   
    bool log_stdout = false;
    if(gContext->GetNumSetting("WeatherLogFlag", 0))
    {
        log_stdout = true;
    } 

    //
    //  Nice ourself
    //
   
    LanguageSettings::load("mythweather");
    
    QString locale = gContext->GetSetting("locale");
    bool wantAnimated = gContext->GetNumSetting("WeatherWantAnimated", 1);   

    WeatherData *weatherData = new WeatherData(NULL, locale, wantAnimated);

    bool haveData = false;
    int retryCnt = 3;
    
    while((haveData == false)&& (retryCnt > 0))
    {
        haveData = weatherData->UpdateBaseData();
        
        if(haveData == false) retryCnt--;
    }

    if (haveData == false)
    {
	fprintf (stderr, "MythWeather: Failed to get weather data."); 
	exit(1);
    }


    bool wantStatic = true;

    // try to get some animated radar maps
    if (wantAnimated && weatherData->GetAnimatedRadarMap()) {
        wantStatic = false;
    }

     // could not get animated radar maps so try to find a static map instead
    if (wantStatic && !weatherData->GetStaticRadarMap()) {
        fprintf (stderr, "Unable to get static radar map\n");
	    exit(1);
    }

    delete gContext;
    return FRONTEND_EXIT_OK;
}

