/* -*- myth -*- */
/**
 * @file keylistdialog.h
 * @author Hal Burch
 * @brief Header file for keylist dialog
 */
#ifndef KEYLISTDIALOG_H
#define KEYLISTDIALOG_H

#include <mythtv/mythdialogs.h>
#include <mythtv/uilistbtntype.h>

#include "keybindings.h"


/**
 * @class KeyListDialog
 * @brief The myth controls configuration class.
 */
class KeyListDialog : virtual public MythThemedDialog
{

    Q_OBJECT

public:
    /**
     * @brief Create a new myth controls wizard.
     * @param parent The main myth window.
     * @param name The name of this window?  I dunno, none of the docs
     * say.
     * @param ui_ok Will be set according to weather the UI was
     * correctly loaded.
     */
    KeyListDialog(MythMainWindow *parent, QString context, bool& ui_ok);

    /**
     * @brief Delete the myth controls object.
     */
    ~KeyListDialog();

    /**
     * @brief Get the currently selected context string.
     * @return The currently selected context string.
     *
     * If no context is selected, an empty string is returned.
     */
    QString getCurrentContext(void) const;

    
protected:

    /**
     * @brief Load up UI.
     * @return true if all UI elements were loaded successfully,
     * otherwise false it returned.
     *
     * This method grabs all of the UI "thingies" that are needed by
     * mythcontrols.  If this method returns false, the plugin should
     * exit since it will probably just core dump.
     */
    bool loadUI();

    /**
     * @brief The key press handler.
     * @param e The key event.
     */
    void keyPressEvent(QKeyEvent *e);

    /**
     * @brief Load the settings for a particular host.
     * @param hostname The host to load settings for.
     */
    void loadHost(const QString & hostname);

    /**
     * @brief Repaint the context and action button lists
     */
    void repaintButtonLists(void);

private slots:

    /**
     * @brief Delete the currently active key.
     */
    void deleteKey();

    /**
     * @brief Save the settings.
     */
    inline void save(void) { key_bindings->commitChanges(); }

    /**
     * @brief Recieves a signal when an item in the keylist list is
     * selected.
     * @param item The selected item.
     */
    void keyListSelected(UIListBtnTypeItem *item);

private:

    UIType *focused;
    UIListBtnType *KeyList;
    UITextType *contextText;
    KeyBindings *key_bindings;
    LayerSet *container;

    QDict<QString> boundKeys;

    QString contextString;
};


#endif /* KEYLISTDIALOG_H */
