#ifndef VIEWSCHEDULEDIFF_H_
#define VIEWSCHEDULEDIFF_H_

#include <qvector.h>
#include <qdatetime.h>
#include <qdom.h>
#include "mythwidgets.h"
#include "mythdialogs.h"
#include "uitypes.h"
#include "xmlparse.h"
#include "programinfo.h"

struct ProgramStruct {
        ProgramInfo *before;
        ProgramInfo *after;
};

class ViewScheduleDiff : public MythDialog
{
    Q_OBJECT
  public:
    ViewScheduleDiff(MythMainWindow *parent, const char *name, QString altDB);
    ~ViewScheduleDiff();

  protected slots:
    void cursorDown(bool page = false);
    void cursorUp(bool page = false);
    void pageDown() { cursorDown(true); }
    void pageUp() { cursorUp(true); }

  protected:
    void paintEvent(QPaintEvent *);
    void keyPressEvent(QKeyEvent *e);
    void customEvent(QCustomEvent *e);

  private:
    void FillList(void);
    void setShowAll(bool all);

    void updateBackground(void);
    void updateList(QPainter *);
    void updateConflict(QPainter *);
    void updateShowLevel(QPainter *);
    void updateInfo(QPainter *);
    void updateRecStatus(QPainter *);

    void LoadWindow(QDomElement &);
    void parseContainer(QDomElement &);
    XMLParse *theme;
    QDomElement xmldata;

    QPixmap myBackground;

    bool conflictBool;
    QString dateformat;
    QString timeformat;
    QString channelFormat;

    QRect listRect;
    QRect infoRect;
    QRect conflictRect;
    QRect showLevelRect;
    QRect recStatusRect;
    QRect fullRect;

    int listsize;

    bool inEvent;
    bool inFill;
    bool needFill;

    unsigned int listPos;

    ProgramInfo *CurrentProgram(void);

    ProgramList recListBefore;
    ProgramList recListAfter;

    QString altDatabase;

    QValueVector<struct ProgramStruct> recList;

    int programCnt;
};

#endif
