#include <sys/vfs.h>
#include <stdio.h>
#include <strings.h>

int main(int argc, char **argv) {
	struct statfs statbuf;
	long long total;
	long long free;

	if (argc > 1) {
		bzero(&statbuf, sizeof(statbuf));
		if (statfs(argv[1], &statbuf) == 0) {
			printf( "Info for  : %s\n", argv[1] );
			printf( "FS Type   : 0x%x\n",
				statbuf.f_type );
			printf( "Tot Blks  : %ld\n", statbuf.f_blocks);
			printf( "Free Blks : %ld\n", statbuf.f_bavail);
			printf( "Block Size: %ld\n", statbuf.f_bsize);

			total  = statbuf.f_blocks;
			total *= statbuf.f_bsize;
			total  = total >> 10;
			printf( "TotalKB   : %8lld KB ((%ld * %ld) >> 10)\n",
				total, statbuf.f_blocks, statbuf.f_bsize);

			free  = statbuf.f_bavail;
			free *= statbuf.f_bsize;
			free  = free >> 10;
			printf( "FreeKB    : %8lld KB ((%ld * %ld) >> 10)\n",
				free, statbuf.f_bavail, statbuf.f_bsize);

			printf( "UsedKB    : %8lld KB (calculated from TotalKB - FreeKB)\n",
				total - free);
		} else {
			printf( "ERROR: statfs() returned non-zero\n" );
			perror("statfs()");
			return( -1 );
		}
	} else {
		printf( "USAGE: %s DIRECTORY\n", argv[0] );
		return( -1 );
	}

	return( 0 );
}
