#!/usr/bin/python

from subprocess import Popen, PIPE
from MythTV import MythDB
import re, os, sys, getopt

SOURCEID=4

def process(buffer):
	lines = buffer.split('\n')
	m = re.match('SCANNING: (?P<freq>[0-9]*) \((?P<chanstring>.*)\)', lines[0])
	if m is None:
		return
	freq = m.group('freq')
	chans = m.group('chanstring').split(', ')
	m = re.match('(?P<table>[a-z\-]*):(?P<channel>[0-9]*)',chans[0])
	table = m.group('table')
	if table == 'qam256':
		table = 'qam_256'
	chan = m.group('channel')
	m = re.match('LOCK: (?P<lock>[a-z0-9]*) \(.*\)',lines[1])
	lock = m.group('lock')

	print "scanning %s:%s (%s) - %s" % (table,chan,freq,lock)
	if lock == 'none':
		return
	if len(lines) == 2:
		print "    no channels found"
		return
	for i in range(2,len(lines)):
#		print lines[i]
		m = re.match('PROGRAM (?P<pid>[0-9]*).*\((?P<type>.*)\)',lines[i])
		if m:
			print "    %s.%s - %s" % (chan,m.group('pid'),m.group('type'))
			continue
		m = re.match('PROGRAM (?P<pid>[0-9]*): (?P<vc>[0-9\.]*)( (?P<callsign>.*))?',lines[i])
		if m is None:
			continue
		pid = m.group('pid')
		virt = m.group('vc')
		if virt == '0':
			virt = '%s.%s' % (chan,pid)
		call = m.group('callsign')
		if call == None:
			call = ''
		print "    %s.%s - %s (%s)" % (chan,pid,virt,call)
		channels.append((freq,table,chan,pid,virt,call))


SOURCE = None
HDHR = None
TUNER = None
mythdb = MythDB()
cursor = mythdb.cursor()

opts, args = getopt.getopt(sys.argv[1:], 'hd:s:t:', ['help','device=','source=','tuner='])
for o,a in opts:
	if o in ('-h','--help'):
		print "%s [-h|--help] [-d<HDHR ID>|--device=<HDHR ID>] [-s<SOURCE ID>|--source=<SOURCE ID>] [-t<0|1>|--tuner=<0|1>]" % sys.argv[0]
		sys.exit(0)
	elif o in ('-d','--device'):
		HDHR = a
	elif o in ('-s','--source'):
		SOURCE = int(a)
	elif o in ('-t','--tuner'):
		TUNER = int(a)

while SOURCE is None:
	validsrc = []
	print "Please choose a channel source:"
	for i in range(0,cursor.execute("""SELECT sourceid,name FROM videosource;""")):
		src = cursor.fetchone()
		validsrc.append(src[0])
		print "  %s. %s" % src
	SOURCE = int(raw_input('> '))
	if SOURCE not in validsrc:
		SOURCE = None

while HDHR is None:
	p = Popen('hdhomerun_config discover',shell=True,stdout=PIPE).stdout
	devs = []
	for i in p.read().split('\n'):
		m = re.match('hdhomerun device (?P<dev>[0-9A-F]{8}) found at (?P<ip>[0-9\.]*)',i)
		if not m:
			continue
		devs.append((m.group('dev'),m.group('ip')))
	if len(devs) == 0:
		print "No devices found"
		sys.exit(-2)
	elif len(devs) == 1:
		print "Using device %s found at %s" % devs[0]
		HDHR = devs[0][0]
	else:
		print "Please choose a HDHomerun device:"
		count = 1
		for dev,ip in devs:
			print "  %d. %s at %s" % (count,dev,ip)
		res = int(raw_input('> '))
		if (res > 0) & (res <= len(devs)):
			HDHR = devs[res-1]

while TUNER is None:
	res = raw_input("Please choose tuner 0 or 1: ")
	if res in ('0','1'):
		TUNER = int(res)

p = Popen('hdhomerun_config %s scan %d' % (HDHR,TUNER),shell=True,stdout=PIPE).stdout
buf = ''
channels = []
newchans = []
while True:
	if buf.count('SCANNING') > 1:
		process(buf[:buf.find('SCANNING',1)].strip())
		buf = buf[buf.find('SCANNING',1):]
		continue
	size = len(buf)
	buf += p.read(100)
	if len(buf) == size:
		process(buf.strip())
		break

mythdb = MythDB()
cursor = mythdb.cursor()
chanid = SOURCE*1000+1
for chan in channels:
	# check for matching multiplex. if not found, create one
	if not cursor.execute("""SELECT mplexid FROM dtv_multiplex WHERE frequency=%s""" % chan[0]):
		print "Multiplex not found, creating new for %s (%s)" % (chan[2],chan[0])
		cursor.execute("""INSERT INTO dtv_multiplex SET sourceid=%d,frequency=%s,constellation='%s',sistandard='',polarity='v'""" % (SOURCE, chan[0],chan[1]))
		cursor.execute("""SELECT mplexid FROM dtv_multiplex WHERE frequency=%s""" % chan[0])
	mplex = cursor.fetchone()[0]

	# check for existing channel at multiplex and serviceid
	if cursor.execute("""SELECT chanid FROM channel WHERE mplexid=%d AND serviceid=%s""" % (mplex,chan[3])):
		res = cursor.fetchone()
		print "Channel %s:%s exists at chanid %d" % (chan[2],chan[3],res[0])
		continue
	
	# check for channel with matching callsign
	if len(chan[5]):
		if cursor.execute("""SELECT chanid,freqid,serviceid FROM channel WHERE callsign='%s'""" % chan[5]):
			res = cursor.fetchone()
			print "Channel %d moved from %s:%d to %s:%s" % (res[0],res[1],res[2],chan[2],chan[3])
			while True:
				res = raw_input('    Update? (yes/no)')
				if res in ('yes','y'):
					cursor.execute("""UPDATE channel SET freqid=%s,mplexid=%s,serviceid=%s WHERE chanid=%d""" % (chan[2],mplex,chan[3],res[0]))
				elif res in ('no','n'):
					break
				else:
					continue
			continue

	# create a new channel, 
	print "New channel - %s:%s %s" % (chan[2],chan[3],chan[5])
	while True:
		if cursor.execute("""SELECT chanid FROM channel WHERE chanid=%d""" % chanid):
			chanid += 1
			continue
		cursor.execute("""INSERT INTO channel SET chanid=%s,channum='%s',freqid=%s,sourceid=%d,callsign='%s',name='%s',mplexid=%s,serviceid=%s,last_record=0""" % (chanid,chan[4],chan[2],SOURCE,chan[5],chan[5],mplex,chan[3]))
		print "Channel %s.%s inserted as %s" % (chan[2],chan[3],chanid)
		break

