Index: mediamonitor-unix.cpp
===================================================================
--- mediamonitor-unix.cpp	(revision 22859)
+++ mediamonitor-unix.cpp	(working copy)
@@ -219,35 +219,34 @@
     ret.replace(QRegExp(".*/"), "/dev/");
 
 #ifdef linux
-    QProcess    *udevinfo = new QProcess();
-    QTextStream  stream(udevinfo);
+    QProcess    udevinfo;
+    QTextStream  stream(&udevinfo);
     QStringList  args;
 
     args << "-q";
     args << "name";
     args << "-rp";
     args << sysfs;
-    udevinfo->start("udevinfo", args);
+    udevinfo.start("udevinfo", args);
 
-    if (!udevinfo->waitForStarted(2000 /*ms*/))
+    if (!udevinfo.waitForStarted(2000 /*ms*/))
     {
         VERBOSE(VB_MEDIA, msg + ", Error - udevinfo failed to start!");
-        udevinfo->deleteLater();
         return ret;
     }
 
-    if (!udevinfo->waitForFinished(2000 /*ms*/))
+    if (!udevinfo.waitForFinished(2000 /*ms*/))
     {
         VERBOSE(VB_MEDIA,
                 msg + ", Error - udevinfo failed to end! Terminating");
-        udevinfo->kill();
-        udevinfo->deleteLater();
+        udevinfo.kill();
+        udevinfo.waitForFinished(2000 /*ms*/);
         return ret;
     }
 
     if ((print_verbose_messages & (VB_MEDIA|VB_EXTRA)) == (VB_MEDIA|VB_EXTRA))
     {
-        udevinfo->setReadChannel(QProcess::StandardError);
+        udevinfo.setReadChannel(QProcess::StandardError);
 
         while (!stream.atEnd())
         {
@@ -256,13 +255,12 @@
         }
     }
 
-    udevinfo->setReadChannel(QProcess::StandardOutput);
+    udevinfo.setReadChannel(QProcess::StandardOutput);
 
     ret = stream.readLine();
     if (ret.startsWith("device not found in database"))
         return ret;
 
-    udevinfo->deleteLater();
 #endif // linux
 
     VERBOSE(VB_MEDIA, msg + "->'" + ret + "'");

