#include <stdio.h>

/*
 * sudo apt-get install libudev-dev
 * cc -ludev -o udev udev.c
 */

/* Next line required at least in mythubuntu 9.04 */
#define LIBUDEV_I_KNOW_THE_API_IS_SUBJECT_TO_CHANGE
#include <libudev.h> 

main()
{
    udevTest("/sys/block/sda");
    udevTest("/sys/block/sdb");
    udevTest("/sys/block/sdc");
    udevTest("/sys/block/sr0");
    udevTest("/sys/block/sdfoo");
    return(0);
}

udevTest(char *sysPath)
{
    const char *devPath;

    struct udev_device *udev_device;
    struct udev        *udev;

    udev = udev_new();

    if(udev == NULL)
    {
        printf("udev_new() failed, no access to udev system?\n");
        return(1);
    }

    udev_device = udev_device_new_from_syspath(udev, sysPath);

    if (udev_device == NULL)
    {
        printf("udev_device_new_from_syspath(%s) failed\n", sysPath);
        return(2);
    }

    devPath = udev_device_get_devnode(udev_device);

    udev_unref(udev);

    if (devPath == NULL)
    {
        printf("udev_device_get_devnode() failed\n");
        return(3);
    }

    printf("%s is known as %s\n", sysPath, devPath);

    return(0);
}
