
// Own header
#include "screensaver-xdg.h"

// QT headers
#include <QWidget>
#include <QDateTime>
#include <QTimer>
#include <QX11Info>
#include <QString>

// Mythdb headers
#include "mythverbose.h"
#include "mythdb.h"

// Mythui headers
#include "mythsystem.h"
#include "mythxdisplay.h"
#include "mythmainwindow.h"

// X11 headers
#include <X11/Xlib.h>

extern "C" {
#include <X11/extensions/dpms.h>
}

#define LOC      QString("ScreenSaverXDGPrivate: ")
#define LOC_WARN QString("ScreenSaverXDGPrivate, Warning: ")
#define LOC_ERR  QString("ScreenSaverXDGPrivate, Error: ")

class ScreenSaverXDGPrivate
{
    friend class ScreenSaverXDG;

  public:
    ScreenSaverXDGPrivate(ScreenSaverXDG *outer) :
        m_xdgscreensaverRunning(false),
        m_display(NULL)
    {
        m_xdgscreensaverRunning =
                myth_system("xdg-screensaver --version >&- 2>&-") == 0;

        if (IsScreenSaverRunning())
        {
            if (m_xdgscreensaverRunning){
            	VERBOSE(VB_GENERAL, LOC + "XDGScreenSaver support enabled");
            }

        }

        m_display = OpenMythXDisplay();
        if (!m_display)
            VERBOSE(VB_IMPORTANT, LOC_ERR + "Failed to open connection to X11 server");
    }

    ~ScreenSaverXDGPrivate()
    {
        // m_resetTimer deleted by ScreenSaverX11 QObject dtor
        delete m_display;
    }

    bool IsScreenSaverRunning(void) const
    {
        return m_xdgscreensaverRunning;
    }

    QString getXWindowId(void)
    {
    	//return window id
    	WId myWId = GetMythMainWindow()->winId();
    	QString windowId = QString("0x%1").arg(myWId, 0, 16);
    	//log it
    	VERBOSE(VB_GENERAL, QString("XDG: xwindowid of MythMainWindow at this time is: %1").arg(windowId));
    	return windowId;
    }

    void ResetScreenSaver(void)
    {
    	VERBOSE(VB_GENERAL, "XDG: ScreenSaverXDG::ResetScreenSaver - doing nothing...");
    }

  private:
    class ScreenSaverState
    {
      public:
        ScreenSaverState() :
            saved(false), timeout(-1), interval(-1),
            preferblank(-1), allowexposure(-1) {}
        bool saved;
        int timeout;
        int interval;
        int preferblank;
        int allowexposure;
    };

  private:
    bool m_xdgscreensaverRunning;

    ScreenSaverState m_state;
    MythXDisplay *m_display;
};

ScreenSaverXDG::ScreenSaverXDG() :
    d(new ScreenSaverXDGPrivate(this))
{
}

ScreenSaverXDG::~ScreenSaverXDG()
{
    delete d;
}

bool ScreenSaverXDG::isXDGInstalled(void)
{
	bool result = myth_system("xdg-screensaver --version >&- 2>&-") == 0;
	if (result){
		VERBOSE(VB_GENERAL, "XDG: XDG-screensaver is supported.");
	}
	else {
		VERBOSE(VB_GENERAL, "XDG: xdg-utils are NOT installed. Failing back to timers and pokes");
	}
	return result;
}

void ScreenSaverXDG::Disable(void)
{
	if (d->m_display)
	{
		if (!d->IsScreenSaverRunning())
			return;
		{
			if (d->m_xdgscreensaverRunning)
			{
				VERBOSE(VB_GENERAL, "XDG: Calling xdg-screensaver suspend windowID");
				myth_system(QString("xdg-screensaver suspend %1 >&- 2>&- &").arg(d->getXWindowId()));
			}
		}
	}
}

void ScreenSaverXDG::Restore(void)
{
	if (d->m_display)
	{
		if (!d->IsScreenSaverRunning())
			return;
		{
			if (d->m_xdgscreensaverRunning)
			{
				VERBOSE(VB_GENERAL, "XDG: Calling xdg-screensaver resume windowID");
				myth_system(QString("xdg-screensaver resume %1 >&- 2>&- &").arg(d->getXWindowId()));
			}
		}
	}
}

void ScreenSaverXDG::Reset(void)
{
    //nothing to see here people
	//go back to your boxed wines and episodes of House
}

bool ScreenSaverXDG::Asleep(void)
{
	//my understanding was only use this as a fallback.
	//the logic here remains in the ScreenSaverX11 class.
    return false;
}

void ScreenSaverXDG::resetSlot(void)
{
    d->ResetScreenSaver();
}
