#!/bin/sh
# Meant to be called as: sh ./generate-vers-cpp.sh "$$VERSION"
# from libmyth.pro

VERSION="Release $1"

#
# svnversion ../.. would be must more precise, but much slower
# svn info tell revision checked out in THIS directory
# svnversion checks the whole repository, detects mixed
# check-outs, etc.
#
# On my machine, svn info takes 0.065 seconds (first time),
# svnversion 8.045 seconds (first time).  Subsequent runs are much
# faster due to caching (0.010 and 0.283, respectively), but I do not
# believe represent the common case.
#
# In any case, here's the alternative to the line below if we want to
# use svnversion (could, in theory, make this a configuration option):
#SVNVERSION="`svnversion ../..`"

SVNVERSION="`svn info . 2>/dev/null | grep Revision | awk '{print $2}'`"
if [ "$SVNVERSION" ]
then
	VERSION="$VERSION, SVN Rev $SVNVERSION"
fi

cat > vers.cpp <<EOF
#include "vers.h" 

const char *myth_source_version = "$VERSION"; 
EOF

